/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPBreakpoint;
import com.ibm.debug.pdt.internal.epdc.EPDC_BasicReply;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.IMultiReply;
import com.ibm.debug.pdt.internal.epdc.IMultiRequest;
import com.ibm.debug.pdt.internal.epdc.IReqHasBreakpointId;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class ERepMultiRequest
extends EPDC_Reply
implements IMultiReply {
    List<EPDC_Reply> fReplies = new ArrayList<EPDC_Reply>();

    ERepMultiRequest(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int size = dataInputStream.readInt();
        if (dataInputStream.skipBytes(16) != 16) {
            PDTCoreUtils.logString(this, "Unable to read all reserved bytes.", 4);
        }
        int i = 0;
        while (i < size) {
            dataInputStream.mark(24);
            if (20L != dataInputStream.skip(20L)) {
                PDTCoreUtils.logString(this, "Unable to skip bytes.", 4);
            }
            int packetLength = dataInputStream.readInt();
            dataInputStream.reset();
            EPDC_Reply reply = EPDC_Reply.decodeReplyStream(dataInputStream, packetLength, engineSession, false, false);
            if (reply != null) {
                this.fReplies.add(reply);
            }
            ++i;
        }
    }

    @Override
    public void setRequest(EPDC_Request request) {
        super.setRequest(request);
        if (request instanceof IMultiRequest) {
            if (this.getReturnCode() == 0 && this.fReplies.size() == 0) {
                EPDC_Request[] requests = ((IMultiRequest)((Object)request)).getRequests();
                int i = 0;
                while (i < requests.length) {
                    EPDC_BasicReply reply = new EPDC_BasicReply(0, this.getEPDCEngineSession());
                    reply.setRequest(requests[i]);
                    requests[i].putProperty(new EPDC_Request.EProperty(20180713, request));
                    requests[i].putProperty(new EPDC_Request.EProperty(20180713, request));
                    this.fReplies.add(reply);
                    ++i;
                }
            } else {
                EPDC_Reply reply;
                if (((IMultiRequest)((Object)request)).getNumRequests() != this.fReplies.size()) {
                    PDTCoreUtils.logString(this, String.format("Mismatch request/reply size. Expected:%d actual:%d.", ((IMultiRequest)((Object)request)).getNumRequests(), this.fReplies.size()), 2);
                }
                EPDC_Request[] requests = ((IMultiRequest)((Object)request)).getRequests();
                int max = Math.min(requests.length, this.fReplies.size());
                int i = 0;
                while (i < max) {
                    reply = this.fReplies.get(i);
                    reply.setRequest(requests[i]);
                    requests[i].putProperty(new EPDC_Request.EProperty(20180713, request));
                    ++i;
                }
                if (max < requests.length) {
                    i = max;
                    while (i < requests.length) {
                        reply = new EPDC_BasicReply(this.getReturnCode(), this.getEPDCEngineSession());
                        reply._message_text = this._message_text;
                        reply.setRequest(requests[i]);
                        requests[i].putProperty(new EPDC_Request.EProperty(20180713, request));
                        this.fReplies.add(reply);
                        ++i;
                    }
                }
            }
        } else {
            PDTCoreUtils.logString(this.getClass(), String.format("Mismatch request. Does not implement IMultiRequest: %s", this.getClass().toString()), 4);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "numReplies", this.fReplies.size());
        EPDC_DumpUtils.beginStructure(dataOutputStream, "Replies");
        int i = 0;
        while (i < this.fReplies.size()) {
            EPDC_Reply reply = this.fReplies.get(i);
            EPDC_DumpUtils.beginStructure(dataOutputStream, NLS.bind((String)"Replies[{0}]: {1} ({2})", (Object[])new Object[]{i, reply.getDescription(), reply.getRequest() == null ? 0 : reply.getRequest().getRequestCode()}));
            EPDC_DumpUtils.startHeader(dataOutputStream);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "reply_type", reply.getDescription());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "reply_code", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "Remote_.*", reply.getReplyCode()));
            EPDC_DumpUtils.writeVariable(dataOutputStream, "length", reply.getTotalBytes());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "return_code", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "ExecRc_.*", reply.getReturnCode()));
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Engine message", reply.getMessageText());
            EPDC_DumpUtils.endHeader(dataOutputStream);
            reply.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
            ++i;
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
    }

    @Override
    public String getDescription() {
        return "Multiple Request";
    }

    @Override
    public EPDC_Reply[] getReplies() {
        return this.fReplies.toArray(new EPDC_Reply[this.fReplies.size()]);
    }

    public Map<Integer, Object> getProperties(ECPBreakpoint breakpointChangeItem, int index) {
        int id = breakpointChangeItem.getId();
        EPDC_Request request = this.getMatchingBreakpointRequest(id);
        if (request != null) {
            return request.getProperties();
        }
        return this.getProperties(index);
    }

    public Map<Integer, Object> getProperties(int index) {
        EPDC_Reply reply;
        if (index < this.fReplies.size() && (reply = this.fReplies.get(index)) != null && reply.getRequest() != null) {
            return reply.getRequest().getProperties();
        }
        return this.getProperties();
    }

    private EPDC_Request getMatchingBreakpointRequest(int breakpointId) {
        int i = 0;
        while (i < this.fReplies.size()) {
            EPDC_Reply reply = this.fReplies.get(i);
            EPDC_Request request = reply.getRequest();
            if (request instanceof IReqHasBreakpointId && ((IReqHasBreakpointId)((Object)request)).getBkptId() == breakpointId) {
                return request;
            }
            ++i;
        }
        return null;
    }
}

