/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EStdLocalFilter;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepLocalFilterList
extends EPDC_Reply {
    private static final EStdLocalFilter[] EMPTYFILTERS = new EStdLocalFilter[0];
    private int _numFilters;
    private EStdLocalFilter[] _filters = EMPTYFILTERS;

    public ERepLocalFilterList(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._numFilters = dataInputStream.readInt();
        int arrayOffset = dataInputStream.readInt();
        dataInputStream.skipBytes(4);
        if (this._numFilters > 0) {
            this._filters = new EStdLocalFilter[this._numFilters];
            OffsetDataInputStream arrayBuffer = new OffsetDataInputStream(byteBuffer, arrayOffset);
            int i = 0;
            while (i < this._numFilters) {
                this._filters[i] = new EStdLocalFilter(byteBuffer, arrayBuffer, engineSession);
                ++i;
            }
        }
    }

    public EStdLocalFilter[] getFilterList() {
        return this._filters;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EStdLocalFilter aLocalFilter = null;
        if (this._filters != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Of_Filters", this._filters.length);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Filters");
            int i = 0;
            while (i < this._filters.length) {
                aLocalFilter = this._filters[i];
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i + "]");
                aLocalFilter.writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Of_Filters", 0);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Filters", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Local filter list";
    }
}

