/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepJobsListGet
extends EPDC_Reply {
    private EStdString[] _jobNames = EMPTYESTDSTRINGS;

    ERepJobsListGet(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int numberOfJobs = dataInputStream.readInt();
        if (numberOfJobs == 0) {
            return;
        }
        this._jobNames = new EStdString[numberOfJobs];
        OffsetDataInputStream offsetDataInputStream = new OffsetDataInputStream(byteBuffer, dataInputStream.readInt());
        int i = 0;
        while (i < numberOfJobs) {
            this._jobNames[i] = new EStdString(offsetDataInputStream, engineSession);
            ++i;
        }
    }

    public String[] getJobNames() {
        String[] jobNames = new String[this._jobNames.length];
        int i = 0;
        while (i < this._jobNames.length) {
            if (this._jobNames[i] != null) {
                jobNames[i] = this._jobNames[i].toString();
            }
            ++i;
        }
        return jobNames;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        String[] jobs = this.getJobNames();
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Jobs", jobs.length);
        EPDC_DumpUtils.beginStructure(dataOutputStream, "Job_Names");
        int i = 0;
        while (i < jobs.length) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Index[" + i + "]", jobs[i]);
            ++i;
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
    }

    @Override
    public String getDescription() {
        return "Get list of jobs";
    }
}

