/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.ERepGetExceptions;
import com.ibm.debug.pdt.internal.epdc.ERepGetLanguages;
import com.ibm.debug.pdt.internal.epdc.ERepGetMacroGroups;
import com.ibm.debug.pdt.internal.epdc.ERepGetPlaybackOptions;
import com.ibm.debug.pdt.internal.epdc.ERepGetViews;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepInitializeDE
extends EPDC_Reply {
    ERepInitializeDE(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int i;
        int offset = dataInputStream.readInt();
        if (this.getEPDCVersion() > 308 && offset != 0) {
            engineSession._engineLabel = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession).toString();
        }
        engineSession._engineID = dataInputStream.readUnsignedShort();
        if (this.getEPDCVersion() > 308) {
            engineSession._engineHardware = dataInputStream.readByte();
            engineSession._engineOS = dataInputStream.readByte();
        } else {
            engineSession._engineOS = (byte)dataInputStream.readShort();
            engineSession._engineHardware = 0;
            switch (engineSession._engineID) {
                case 9: {
                    engineSession._engineOS = (byte)11;
                    engineSession._engineHardware = (byte)3;
                    break;
                }
                case 11: {
                    engineSession._engineOS = (byte)12;
                    engineSession._engineHardware = (byte)4;
                    break;
                }
            }
        }
        engineSession._defaultSettings = dataInputStream.readInt();
        offset = dataInputStream.readInt();
        if (this.getEPDCVersion() > 307 && offset != 0) {
            engineSession.setEngineExtensionID(new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession).toString());
        }
        offset = dataInputStream.readInt();
        if (this.getEPDCVersion() > 307 && offset != 0) {
            engineSession._engineVersionString = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession).toString();
        }
        offset = dataInputStream.readInt();
        if (this.getEPDCVersion() > 307 && offset != 0) {
            engineSession._OSVersionString = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession).toString();
        }
        dataInputStream.skipBytes(4);
        int numberOfViews = engineSession.fNumberViews = dataInputStream.readUnsignedShort();
        int numRepTypes = dataInputStream.readUnsignedShort();
        int numLangs = dataInputStream.readInt();
        int numExceptions = dataInputStream.readInt();
        dataInputStream.skipBytes(4);
        byte numPlaybackOptions = dataInputStream.readByte();
        dataInputStream.skipBytes(3);
        offset = dataInputStream.readInt();
        if (offset != 0) {
            engineSession.fViewInfos = new ERepGetViews[numberOfViews + 1];
            OffsetDataInputStream viewDataInputStream = new OffsetDataInputStream(byteBuffer, offset);
            engineSession.fViewInfos[0] = null;
            i = 1;
            while (i <= numberOfViews) {
                engineSession.fViewInfos[i] = new ERepGetViews(byteBuffer, viewDataInputStream, engineSession);
                ++i;
            }
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            engineSession._repNames = new String[numRepTypes + 1];
            OffsetDataInputStream nameDataInputStream = new OffsetDataInputStream(byteBuffer, offset);
            i = 1;
            while (i < engineSession._repNames.length) {
                engineSession._repNames[i] = new EStdString(nameDataInputStream, engineSession).toString();
                ++i;
            }
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            engineSession._languageInfo = new ERepGetLanguages[numLangs];
            OffsetDataInputStream langDataInputStream = new OffsetDataInputStream(byteBuffer, offset);
            i = 0;
            while (i < numLangs) {
                engineSession._languageInfo[i] = new ERepGetLanguages(byteBuffer, langDataInputStream, engineSession);
                ++i;
            }
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            engineSession._exceptionsInfo = new ERepGetExceptions[numExceptions];
            OffsetDataInputStream excpDataInputStream = new OffsetDataInputStream(byteBuffer, offset);
            i = 0;
            while (i < numExceptions) {
                engineSession._exceptionsInfo[i] = new ERepGetExceptions(byteBuffer, excpDataInputStream, engineSession);
                ++i;
            }
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            OffsetDataInputStream offsetDataInputStream = new OffsetDataInputStream(byteBuffer, offset);
            engineSession._macroGroups = new ERepGetMacroGroups(byteBuffer, offsetDataInputStream, engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            engineSession.fPlaybackOptions = new ERepGetPlaybackOptions[numPlaybackOptions];
            OffsetDataInputStream playbackInputStream = new OffsetDataInputStream(byteBuffer, offset);
            i = 0;
            while (i < numPlaybackOptions) {
                engineSession.fPlaybackOptions[i] = new ERepGetPlaybackOptions(byteBuffer, playbackInputStream, engineSession);
                ++i;
            }
        }
        dataInputStream.skipBytes(8);
        engineSession.initialize();
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_EngineSession engineSession = this.getEPDCEngineSession();
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Debug_Engine_ID", engineSession.getEngineIDString() + " [" + engineSession.getEngineID() + "]");
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Engine label", engineSession.getEngineLabel());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Engine Hardware", engineSession.getEngineHardwareString() + " [" + engineSession._engineHardware + "]");
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Engine OS", engineSession.getEngineOSString() + " [" + engineSession._engineOS + "]");
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Default_Setting", engineSession._defaultSettings);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Engine extension id", engineSession.getEngineExtensionID());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Engine Version", engineSession.getEngineVersionString());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "OS version", engineSession.getOSVersionString());
        EPDC_DumpUtils.beginStructure(dataOutputStream, "View_Information");
        ERepGetViews[] viewInfo = engineSession.getViewInformation();
        int i = 0;
        while (i < viewInfo.length) {
            if (viewInfo[i] != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i + "]");
                viewInfo[i].writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
            }
            ++i;
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
        String[] repNames = engineSession.getRepNames();
        EPDC_DumpUtils.beginStructure(dataOutputStream, "Rep_Name");
        int i2 = 1;
        while (i2 < repNames.length) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Index[" + i2 + "]", repNames[i2]);
            ++i2;
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
        ERepGetLanguages[] langs = engineSession.getLanguageInfo();
        EPDC_DumpUtils.beginStructure(dataOutputStream, "Language_Info");
        int i3 = 0;
        while (i3 < langs.length) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i3 + "]");
            langs[i3].writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
            ++i3;
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
        ERepGetExceptions[] excps = engineSession.getExceptionInfo();
        EPDC_DumpUtils.beginStructure(dataOutputStream, "Exceptions_Information");
        int i4 = 0;
        while (i4 < excps.length) {
            excps[i4].writeEPDC(dataOutputStream);
            ++i4;
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
        ERepGetMacroGroups macroGroups = engineSession._macroGroups;
        if (macroGroups != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, macroGroups.getDescription());
            macroGroups.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        }
    }

    @Override
    public String getDescription() {
        return "Initialize debug engine";
    }
}

