/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EStdGlobalSymbol;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepGlobalSymbolQuery
extends EPDC_Reply {
    private static final EStdGlobalSymbol[] EMPTYGLOBALSYMS = new EStdGlobalSymbol[0];
    private int _numberSymbols;
    private EStdGlobalSymbol[] _symbolArray = EMPTYGLOBALSYMS;

    public ERepGlobalSymbolQuery(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._numberSymbols = dataInputStream.readInt();
        int arrayOffset = dataInputStream.readInt();
        dataInputStream.skipBytes(4);
        if (this._numberSymbols == 0 || arrayOffset == 0) {
            return;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (OffsetDataInputStream arrayBuffer = new OffsetDataInputStream(byteBuffer, arrayOffset);){
            this._symbolArray = new EStdGlobalSymbol[this._numberSymbols];
            int i = 0;
            while (i < this._numberSymbols) {
                int offset = arrayBuffer.readInt();
                this._symbolArray[i] = offset != 0 ? new EStdGlobalSymbol(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession) : null;
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public EStdGlobalSymbol[] getSymbolArray() {
        return this._symbolArray;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EStdGlobalSymbol aGlobalVariable = null;
        if (this._symbolArray != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_GlobalSymbols", this._symbolArray.length);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Globals");
            int i = 0;
            while (i < this._symbolArray.length) {
                aGlobalVariable = this._symbolArray[i];
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i + "]");
                aGlobalVariable.writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_GlobalSymbols", 0);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Globals", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Get global symbol list";
    }
}

