/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EStdGlobalVariable;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepGlobalList
extends EPDC_Reply {
    private static final EStdGlobalVariable[] EMPTYGLOBALVARS = new EStdGlobalVariable[0];
    private int _numGlobals;
    private EStdGlobalVariable[] _globals = EMPTYGLOBALVARS;

    public ERepGlobalList(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._numGlobals = dataInputStream.readInt();
        this._globals = new EStdGlobalVariable[this._numGlobals];
        int arrayOffset = dataInputStream.readInt();
        dataInputStream.skipBytes(4);
        OffsetDataInputStream arrayBuffer = new OffsetDataInputStream(byteBuffer, arrayOffset);
        int i = 0;
        while (i < this._numGlobals) {
            this._globals[i] = new EStdGlobalVariable(byteBuffer, arrayBuffer, engineSession);
            ++i;
        }
    }

    public EStdGlobalVariable[] getGlobalList() {
        return this._globals;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EStdGlobalVariable aGlobalVariable = null;
        if (this._globals != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Of_Globals", this._globals.length);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Globals");
            int i = 0;
            while (i < this._globals.length) {
                aGlobalVariable = this._globals[i];
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i + "]");
                aGlobalVariable.writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Of_Globals", 0);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Globals", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Global list";
    }
}

