/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepGetViews
extends EPDC_Structures {
    private short _viewType;
    private short _viewClass;
    private EStdString _viewName;
    private byte _viewAttr;
    private static final int FIXED_LENGTH = 10;

    public ERepGetViews(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._viewType = dataInputStream.readShort();
        this._viewClass = dataInputStream.readShort();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._viewName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._viewAttr = dataInputStream.readByte();
        dataInputStream.skipBytes(1);
    }

    public String getName() {
        if (this._viewName != null) {
            return this._viewName.toString();
        }
        return null;
    }

    public boolean hasPrefixArea() {
        return this._viewType == 2;
    }

    public short getKind() {
        return this._viewClass;
    }

    private String getViewAttr() {
        if (this.isMonitorCapable() && this.isLineBreakpointCapable()) {
            return "MONITOR_CAPABLE and LINEBP_CAPABLE";
        }
        if (this.isMonitorCapable()) {
            return "MONITOR_CAPABLE";
        }
        if (this.isLineBreakpointCapable()) {
            return "LINEBP_CAPABLE";
        }
        return "NONE";
    }

    public boolean isMonitorCapable() {
        return (this._viewAttr & 0x80) != 0;
    }

    public boolean isLineBreakpointCapable() {
        return (this._viewAttr & 0x40) != 0;
    }

    @Override
    int getFixedLen() {
        return 10;
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + ERepGetViews.getTotalBytes(this._viewName);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "View_Type", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "Viewtype_.*", this._viewType));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "View_Class", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "View_Class_.*", this._viewClass));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "View_Name", this.getName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "View_Attr", this.getViewAttr());
    }

    @Override
    public String getDescription() {
        return "Get view information";
    }
}

