/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepGetStackColumns
extends EPDC_Structures {
    private int _columnID;
    private EStdString _columnName;
    private int _columnNameAlignment;
    private int _columnTextAlignment;
    private static final int FIXED_LENGTH = 16;

    ERepGetStackColumns(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._columnID = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._columnName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._columnNameAlignment = dataInputStream.readInt();
        this._columnTextAlignment = dataInputStream.readInt();
    }

    public int getColumnID() {
        return this._columnID;
    }

    public String getColumnName() {
        if (this._columnName != null) {
            return this._columnName.toString();
        }
        return null;
    }

    public int getColumnNameAlignment() {
        return this._columnNameAlignment;
    }

    public int getColumnTextAlignment() {
        return this._columnTextAlignment;
    }

    @Override
    int getFixedLen() {
        return 16;
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + ERepGetStackColumns.getTotalBytes(this._columnName);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ColumnID", this.getColumnID());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ColumnName", this.getColumnName().isEmpty() ? "NULL_STRING" : this.getColumnName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ColumnNameAlignment", this.getColumnNameAlignment());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ColumnTextAlignment", this.getColumnTextAlignment());
    }

    @Override
    public String getDescription() {
        return "Get stack columns";
    }
}

