/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepGetRegistersGroups
extends EPDC_Structures {
    private int _groupID;
    private EStdString _groupName;
    private static final int FIXED_LENGTH = 8;

    ERepGetRegistersGroups(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._groupID = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._groupName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public int getGroupID() {
        return this._groupID;
    }

    public String getGroupName() {
        if (this._groupName != null) {
            return this._groupName.toString();
        }
        return null;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Group_ID", this.getGroupID());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Group_Name", this.getGroupName());
    }

    @Override
    int getFixedLen() {
        return 8;
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + ERepGetRegistersGroups.getTotalBytes(this._groupName);
    }

    @Override
    public String getDescription() {
        return "Register groups";
    }
}

