/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepGetProcessColumns
extends EPDC_Structures {
    private int _columnID;
    private EStdString _columnName;
    private int _columnNameAlignment;
    private int _columnTextAlignment;
    private static final int FIXED_LENGTH = 16;

    ERepGetProcessColumns(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._columnID = dataInputStream.readInt();
        int columnNameOffset = dataInputStream.readInt();
        this._columnNameAlignment = dataInputStream.readInt();
        this._columnTextAlignment = dataInputStream.readInt();
        if (columnNameOffset != 0) {
            this._columnName = new EStdString(new OffsetDataInputStream(byteBuffer, columnNameOffset), engineSession);
        }
    }

    @Override
    int getFixedLen() {
        return 16;
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + ERepGetProcessColumns.getTotalBytes(this._columnName);
    }

    public String getColumnName() {
        if (this._columnName == null) {
            return null;
        }
        return this._columnName.toString();
    }

    public int getColumnNameAlignment() {
        return this._columnNameAlignment;
    }

    public int getColumnTextAlignment() {
        return this._columnTextAlignment;
    }

    public int getColumnID() {
        return this._columnID;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ColumnID", this.getColumnID());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ColumnName", this.getColumnName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ColumnNameAlignment", this.getColumnNameAlignment());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ColumnTextAlignment", this.getColumnTextAlignment());
    }

    @Override
    public String getDescription() {
        return "Get process columns";
    }
}

