/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ERepGetPlaybackOptions
extends EPDC_Structures {
    private int fId;
    private EStdString fName;
    private int fType;
    private String fStringValue;
    private boolean fBooleanValue;

    public static List<ERepGetPlaybackOptions> getGlobalOptions(ERepGetPlaybackOptions[] options) {
        ArrayList<ERepGetPlaybackOptions> result = new ArrayList<ERepGetPlaybackOptions>();
        if (options != null) {
            int i = 0;
            while (i < options.length) {
                if (!ERepGetPlaybackOptions.isLaunchType(options[i].getType())) {
                    result.add(options[i]);
                }
                ++i;
            }
        }
        return result;
    }

    public static List<ERepGetPlaybackOptions> getProgramOptions(ERepGetPlaybackOptions[] options) {
        ArrayList<ERepGetPlaybackOptions> result = new ArrayList<ERepGetPlaybackOptions>();
        if (options != null) {
            int i = 0;
            while (i < options.length) {
                if (ERepGetPlaybackOptions.isLaunchType(options[i].getType())) {
                    result.add(options[i]);
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean isLaunchType(int type) {
        return type == 3 || type == 5 || type == 4;
    }

    public static boolean isListType(int type) {
        return type == 5 || type == 2;
    }

    public static boolean isStringType(int type) {
        return type == 4 || type == 1;
    }

    public ERepGetPlaybackOptions(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this.fId = dataInputStream.readInt();
        int nameOffset = dataInputStream.readInt();
        if (nameOffset > 0) {
            this.fName = new EStdString(new OffsetDataInputStream(byteBuffer, nameOffset), engineSession);
        }
        this.fType = dataInputStream.readInt();
        dataInputStream.skipBytes(32);
        if (this.fName == null || this.fName.toString().trim().length() == 0) {
            PDTCoreUtils.logString(this, "Invalid Playback option name returned from debug engine:" + engineSession.getEngineLabel(), 4);
        }
        if (this.fType < 0 || this.fType > 5) {
            PDTCoreUtils.logString(this, "Invalid Playback option type returned from debug engine:" + engineSession.getEngineLabel() + ":" + this.fType, 4);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ERepGetPlaybackOptions) {
            ERepGetPlaybackOptions option = (ERepGetPlaybackOptions)o;
            return option.getId() == this.fId;
        }
        return super.equals(o);
    }

    public boolean getBooleanValue() {
        return this.fBooleanValue;
    }

    public int getId() {
        return this.fId;
    }

    public EStdString getName() {
        return this.fName;
    }

    public String getStringValue() {
        return this.fStringValue;
    }

    public int getType() {
        return this.fType;
    }

    public void setBooleanValue(boolean value) {
        this.fBooleanValue = value;
    }

    public void setStringValue(String value) {
        this.fStringValue = value;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] TYPES = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(0, "boolean"), new EPDC_DumpUtils.NameVal(3, "boolean_launch"), new EPDC_DumpUtils.NameVal(2, "boolean_list"), new EPDC_DumpUtils.NameVal(5, "boolean_list_launch"), new EPDC_DumpUtils.NameVal(1, "booleanStringLaunch"), new EPDC_DumpUtils.NameVal(4, "boolean_list_launch")};
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Plaback_Option_ID", this.fId);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Plaback_Option_Name", this.fName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Plaback_Option_Type", EPDC_DumpUtils.getAttrbuteName(TYPES, this.fType));
    }

    @Override
    public String getDescription() {
        return "Playback options";
    }

    public int hashCode() {
        return super.hashCode() + this.getId();
    }
}

