/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepGetNextStackEntry
extends EPDC_Structures {
    private EStdString[] _columns;
    private EStdString _stackEntryRemStkSize;
    private int _numOfParms;
    private EStdView[] _stackEntryViewInfo;
    private int _stackID;
    private int _index;
    private static final int FIXED_LENGTH = 54;
    private static final int NUMCOLS = 9;

    ERepGetNextStackEntry(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int offset;
        this._index = this._stackID = dataInputStream.readUnsignedShort();
        this._columns = new EStdString[9];
        int i = 0;
        while (i < 9) {
            offset = dataInputStream.readInt();
            if (offset != 0) {
                this._columns[i] = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
            }
            ++i;
        }
        offset = dataInputStream.readInt();
        if (offset != 0) {
            this._stackEntryRemStkSize = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._numOfParms = dataInputStream.readInt();
        dataInputStream.skipBytes(4);
        offset = dataInputStream.readInt();
        if (offset != 0) {
            this._stackEntryViewInfo = new EStdView[engineSession.getNumViews() + 1];
            this._stackEntryViewInfo[0] = null;
            OffsetDataInputStream offsetDataInputStream = new OffsetDataInputStream(byteBuffer, offset);
            int i2 = 1;
            while (i2 < this._stackEntryViewInfo.length) {
                this._stackEntryViewInfo[i2] = new EStdView(offsetDataInputStream);
                ++i2;
            }
        }
    }

    public ERepGetNextStackEntry(ERepGetNextStackEntry stkEntry) {
        this._columns = stkEntry._columns;
        this._stackEntryRemStkSize = stkEntry._stackEntryRemStkSize;
        this._numOfParms = stkEntry._numOfParms;
        this._stackEntryViewInfo = stkEntry._stackEntryViewInfo;
        this._stackID = stkEntry._stackID;
        this._index = stkEntry._index;
    }

    public String[] getColumns() {
        String[] str = new String[this._columns.length];
        int i = 0;
        while (i < str.length) {
            if (this._columns[i] != null) {
                str[i] = this._columns[i].toString();
            }
            ++i;
        }
        return str;
    }

    public String getRemStkSize() {
        if (this._stackEntryRemStkSize != null) {
            return this._stackEntryRemStkSize.toString();
        }
        return null;
    }

    public int getNumOfParms() {
        return this._numOfParms;
    }

    public EStdView[] getViewInfo() {
        return this._stackEntryViewInfo;
    }

    @Deprecated
    public void setViewInfo(EStdView[] viewInfo) {
        this._stackEntryViewInfo = viewInfo;
    }

    @Override
    protected int getFixedLen() {
        return 54;
    }

    @Override
    protected int getVarLen() {
        int total = 0;
        int i = 0;
        while (i < this._columns.length) {
            total += ERepGetNextStackEntry.getTotalBytes(this._columns[i]);
            ++i;
        }
        total += ERepGetNextStackEntry.getTotalBytes(this._stackEntryRemStkSize);
        return total += this._stackEntryViewInfo.length * 12;
    }

    public int getId() {
        return this._stackID;
    }

    protected void setIndex(int s) {
        this._index = s;
    }

    public int getIndex() {
        return this._index;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Stack_Frame_ID", this.getId());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Remaining_Stack_Size", this.getRemStkSize());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "NumOfParms", this._numOfParms);
        int i = 0;
        while (i < this._columns.length - 1) {
            if (this._columns[i] != null) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Column" + i, this._columns[i].toString());
            }
            ++i;
        }
        if (this._stackEntryViewInfo != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Stack_EntryView_Info");
            int j = 0;
            while (j < this._stackEntryViewInfo.length) {
                if (this._stackEntryViewInfo[j] != null) {
                    EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + j + "]");
                    this._stackEntryViewInfo[j].writeEPDC(dataOutputStream);
                    EPDC_DumpUtils.endStructure(dataOutputStream);
                }
                ++j;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Stack_EntryView_Info", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Stack frame entry";
    }
}

