/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.ECPStorage;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

@Deprecated
public class ERepGetNextMonitorStorageLine
extends EPDC_Structures {
    private int _lineNumber;
    private EStdString _line;
    private String _address;
    private String[] _storage;
    private static final int FIXED_LENGTH = 0;

    public int outputTable(DataOutputStream dataOutputStream, int storageOffset) throws IOException {
        dataOutputStream.writeInt(this._lineNumber);
        ERepGetNextMonitorStorageLine.writeOffsetOrZero(dataOutputStream, storageOffset, this._line);
        int bytesNeeded = 0;
        if (this._line != null) {
            bytesNeeded = this._line.getTotalBytes();
        }
        return bytesNeeded;
    }

    public int outputStorage(DataOutputStream dataOutputStream) throws IOException {
        int bytesUsed = 0;
        if (this._line != null) {
            this._line.output(dataOutputStream);
            bytesUsed = this._line.getTotalBytes();
        }
        return bytesUsed;
    }

    ERepGetNextMonitorStorageLine(byte[] byteBuffer, DataInputStream dataInputStream, ECPStorage owner, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._lineNumber = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._line = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
            String line = this._line.toString();
            int startingIndex = owner.beginAddress();
            int indexOfNull = line.indexOf(0, startingIndex);
            this._address = line.substring(startingIndex, indexOfNull);
            switch (owner.getUnitStyle()) {
                case 1: 
                case 15: 
                case 17: 
                case 18: {
                    this._storage = new String[2];
                    startingIndex = owner.endStorage();
                    indexOfNull = line.indexOf(0, startingIndex);
                    this._storage[1] = line.substring(startingIndex, indexOfNull);
                    break;
                }
                default: {
                    this._storage = new String[1];
                }
            }
            startingIndex = owner.beginStorage();
            indexOfNull = line.indexOf(0, startingIndex);
            this._storage[0] = line.substring(startingIndex, indexOfNull);
        }
    }

    @Override
    int getFixedLen() {
        return 0;
    }

    @Override
    int getVarLen() {
        return ERepGetNextMonitorStorageLine.getTotalBytes(this._line);
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public String getAddress() {
        return this._address;
    }

    public String[] getStorage() {
        return this._storage;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Monitor_Storage_LineNum", this.getLineNumber());
        if (this._line != null && this._line.toString() != null && this._line.toString().getBytes()[0] != 0) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Monitor_Storage_Line", this._line.toString());
        }
        if (this.getAddress() != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Address", this.getAddress());
        }
        if (this._storage != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Storage");
            int i = 0;
            while (i < this._storage.length) {
                if (this._storage[i] != null) {
                    EPDC_DumpUtils.writeVariable(dataOutputStream, "Index[" + i + "]", this._storage[i]);
                }
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "(Deprecated) Storage line";
    }
}

