/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepGetMacroGroups
extends EPDC_Structures {
    private String[] fMacroGroups;

    public ERepGetMacroGroups(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int numMacroGroups = dataInputStream.readInt();
        this.fMacroGroups = new String[numMacroGroups];
        int i = 0;
        while (i < this.fMacroGroups.length) {
            EStdString macroGroup = new EStdString(dataInputStream, engineSession);
            this.fMacroGroups[i] = macroGroup.toString();
            ++i;
        }
    }

    public String[] getMacroGroups() {
        return this.fMacroGroups;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        int i = 0;
        while (i < this.fMacroGroups.length) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "[" + i + "]", this.fMacroGroups[i]);
            ++i;
        }
    }

    @Override
    public String getDescription() {
        return "Macro groups";
    }
}

