/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepGetListItem
extends EPDC_Structures {
    private short _listType;
    private EStdString _item;
    private EStdString _metadata1;
    private EStdString _metadata2;
    private int _metadata3;
    private int _metadata4;
    private static final int FIXED_LENGTH = 24;

    public ERepGetListItem(String item, String metadata1, String metadata2, int metadata3, int metadata4, EPDC_EngineSession engineSession) {
        super(engineSession);
        this._item = new EStdString(item, engineSession);
        this._metadata1 = new EStdString(metadata1, engineSession);
        this._metadata2 = new EStdString(metadata2, engineSession);
        this._metadata3 = metadata3;
        this._metadata4 = metadata4;
    }

    ERepGetListItem(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._listType = dataInputStream.readShort();
        switch (this._listType) {
            case 1: 
            case 5: {
                int offset = dataInputStream.readInt();
                if (offset != 0) {
                    this._item = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
                }
                if ((offset = dataInputStream.readInt()) != 0) {
                    this._metadata1 = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
                }
                if ((offset = dataInputStream.readInt()) != 0) {
                    this._metadata2 = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
                }
                this._metadata3 = dataInputStream.readInt();
                this._metadata4 = dataInputStream.readInt();
                break;
            }
            case 2: 
            case 6: {
                int offset = dataInputStream.readInt();
                if (offset != 0) {
                    this._item = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
                }
                if ((offset = dataInputStream.readInt()) != 0) {
                    this._metadata1 = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
                }
                this._metadata3 = dataInputStream.readInt();
                break;
            }
        }
    }

    @Override
    int getFixedLen() {
        return 24;
    }

    @Override
    int getVarLen() {
        return ERepGetListItem.getTotalBytes(this._item) + ERepGetListItem.getTotalBytes(this._metadata1) + ERepGetListItem.getTotalBytes(this._metadata2) + super.getVarLen();
    }

    public String getItem() {
        if (this._item != null) {
            return this._item.toString();
        }
        return null;
    }

    public String getMetadata1() {
        if (this._metadata1 != null) {
            return this._metadata1.toString();
        }
        return null;
    }

    public String getMetadata2() {
        if (this._metadata2 != null) {
            return this._metadata2.toString();
        }
        return null;
    }

    public int getMetadata3() {
        return this._metadata3;
    }

    public int getMetadata4() {
        return this._metadata4;
    }

    private short getListType() {
        return this._listType;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ListType", this.getListType());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Item", this.getItem());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Metadata1", this.getMetadata1());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Metadata2", this.getMetadata2());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Metadata3", this.getMetadata3());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Metadata4", this.getMetadata4());
    }

    @Override
    public String getDescription() {
        return "List item (" + this.getItem() + ")";
    }
}

