/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.ERepGetListItem;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepGetList
extends EPDC_Reply {
    private static final ERepGetListItem[] EMPTYENTRIES = new ERepGetListItem[0];
    private ERepGetListItem[] _items = EMPTYENTRIES;

    ERepGetList(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int numberOfEntries = dataInputStream.readInt();
        this._items = new ERepGetListItem[numberOfEntries];
        if (numberOfEntries == 1) {
            this._items[0] = new ERepGetListItem(byteBuffer, dataInputStream, engineSession);
        } else {
            int i = 0;
            while (i < numberOfEntries) {
                this._items[i] = new ERepGetListItem(byteBuffer, new OffsetDataInputStream(byteBuffer, dataInputStream.readInt()), engineSession);
                ++i;
            }
        }
    }

    public ERepGetListItem[] getItems() {
        return this._items;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        if (this._items != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Matches", this._items.length);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Results");
            int i = 0;
            while (i < this._items.length) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, this._items[i].getDescription());
                this._items[i].writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Matches", 0);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "ItemList", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Get list";
    }
}

