/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepGetLanguages
extends EPDC_Structures {
    private int _langID;
    private EStdString _language;
    private static final int FIXED_LENGTH = 8;

    public ERepGetLanguages(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._langID = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._language = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public String getLanguageName() {
        if (this._language != null) {
            return this._language.toString();
        }
        return null;
    }

    public int getLanguageID() {
        return this._langID;
    }

    @Override
    int getFixedLen() {
        return 8;
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + ERepGetLanguages.getTotalBytes(this._language);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Languages_ID", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "LANG_.*", this._langID));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Language_Name", this.getLanguageName());
    }

    @Override
    public String getDescription() {
        return "Get languages";
    }
}

