/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepGetFile
extends EPDC_Reply {
    private static final byte EOF = 1;
    private static final byte COMPRESSED = 2;
    private byte fFlags;
    private int fCurrentPosn;
    private byte[] fContent;

    ERepGetFile(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dis, engineSession);
        this.fFlags = dis.readByte();
        dis.skipBytes(3);
        this.fCurrentPosn = dis.readInt();
        int numBytes = dis.readInt();
        this.fContent = new byte[numBytes];
        dis.readFully(this.fContent);
    }

    public boolean isCompressed() {
        return (this.fFlags & 2) != 0;
    }

    public boolean isEOF() {
        return (this.fFlags & 1) != 0;
    }

    public int getCurrentPosn() {
        return this.fCurrentPosn;
    }

    public byte[] getContent() {
        return this.fContent;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] attrConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(1, "EOF"), new EPDC_DumpUtils.NameVal(2, "Compressed")};
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Flags", this.fFlags, attrConstants);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Current Posn", this.fCurrentPosn);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Number bytes", this.fContent.length);
        EPDC_DumpUtils.writeBytes(dataOutputStream, "Content", this.fContent, 0);
    }

    @Override
    public String getDescription() {
        return "Get File Contents";
    }
}

