/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class ERepGetExceptions
extends EPDC_Structures
implements Serializable {
    private static final transient int FIXED_LENGTH = 8;
    private static final long serialVersionUID = 20050307L;
    private int _exceptionStatus;
    private EStdString _exceptionName;

    ERepGetExceptions(int status, String name, EPDC_EngineSession engineSession) {
        super(engineSession);
        this._exceptionStatus = status;
        this._exceptionName = new EStdString(name, engineSession);
    }

    ERepGetExceptions(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._exceptionStatus = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._exceptionName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public int getExceptionStatus() {
        return this._exceptionStatus;
    }

    public String getExceptionName() {
        return this._exceptionName.toString();
    }

    @Override
    int getFixedLen() {
        return 8;
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + ERepGetExceptions.getTotalBytes(this._exceptionName);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        boolean enabled = this.getExceptionStatus() == 1;
        EPDC_DumpUtils.writeVariable(dataOutputStream, this._exceptionName.toString(), enabled ? "True" : "False");
    }

    @Override
    public String getDescription() {
        return "Get exceptions";
    }
}

