/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EExtString;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepGetEventContent
extends EPDC_Reply {
    private short fEventType;
    private EExtString fXML;

    ERepGetEventContent(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this.fEventType = dataInputStream.readShort();
        dataInputStream.readShort();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this.fXML = new EExtString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public short getEventType() {
        return this.fEventType;
    }

    public String getXML() {
        if (this.fXML == null) {
            return null;
        }
        return this.fXML.toString();
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Event type", this.fEventType);
        if (this.fXML != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "XML", this.fXML.toString());
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "XML", "null");
        }
    }

    @Override
    public String getDescription() {
        return "Receive XML for an event";
    }
}

