/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepEntryWhere
extends EPDC_Reply {
    private static final EStdView[] EMPTYLOCATIONS = new EStdView[0];
    private EStdView[] _context = EMPTYLOCATIONS;

    ERepEntryWhere(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        dataInputStream.skipBytes(4);
        this._context = new EStdView[engineSession.getNumViews() + 1];
        this._context[0] = null;
        int i = 1;
        while (i < this._context.length) {
            this._context[i] = new EStdView(dataInputStream);
            ++i;
        }
    }

    public EStdView[] getContexts() {
        return this._context;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EStdView aView = null;
        if (this._context != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Context_Information");
            int i = 0;
            while (i < this._context.length) {
                aView = this._context[i];
                if (aView != null) {
                    EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i + "]");
                    aView.writeEPDC(dataOutputStream);
                    EPDC_DumpUtils.endStructure(dataOutputStream);
                }
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Context_Information", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Get context for entry point";
    }
}

