/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.ERepEntryGetNext;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepEntrySearch
extends EPDC_Reply {
    private static final ERepEntryGetNext[] EMPTYENTRIES = new ERepEntryGetNext[0];
    private ERepEntryGetNext[] _entries = EMPTYENTRIES;

    ERepEntrySearch(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int numberOfEntries = dataInputStream.readInt();
        if (numberOfEntries == 0 && this.getReturnCode() == 0) {
            this._return_code = 4;
        }
        this._entries = new ERepEntryGetNext[numberOfEntries];
        if (numberOfEntries == 1) {
            this._entries[0] = new ERepEntryGetNext(byteBuffer, dataInputStream, engineSession);
        } else {
            int i = 0;
            while (i < numberOfEntries) {
                this._entries[i] = new ERepEntryGetNext(byteBuffer, new OffsetDataInputStream(byteBuffer, dataInputStream.readInt()), engineSession);
                ++i;
            }
        }
    }

    public ERepEntryGetNext[] getEntries() {
        return this._entries;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        if (this._entries != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Matches", this._entries.length);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Results");
            int i = 0;
            while (i < this._entries.length) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, this._entries[i].getDescription());
                this._entries[i].writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Matches", 0);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "BreakIdList", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Search for entry point";
    }
}

