/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepEntryGetNext
extends EPDC_Structures {
    private int _entryID;
    private EStdString _entryName;
    private EStdString _demangledName;
    private EStdString _entryReturnType;
    private EStdView _EStdView;
    private static final int FIXED_LENGTH = 16;

    public ERepEntryGetNext(int entryID, String entryName, String entryReturnType, EStdView eStdView, EPDC_EngineSession engineSession) {
        super(engineSession);
        this._entryID = entryID;
        this._demangledName = this._entryName = new EStdString(entryName, engineSession);
        this._entryReturnType = new EStdString(entryReturnType, engineSession);
        this._EStdView = eStdView;
    }

    ERepEntryGetNext(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._entryID = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._entryName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._demangledName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._entryReturnType = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._EStdView = new EStdView(dataInputStream);
    }

    public int getEntryID() {
        return this._entryID;
    }

    public String getName() {
        String name = this.getDemangledName();
        if (name != null && name.length() != 0) {
            return name;
        }
        name = this.getEntryName();
        if (name != null && name.length() != 0) {
            return name;
        }
        return "<unknown>";
    }

    public String getEntryReturnType() {
        if (this._entryReturnType != null) {
            return this._entryReturnType.toString();
        }
        return null;
    }

    public EStdView getEStdView() {
        return this._EStdView;
    }

    public void setContext(EStdView context) {
        this._EStdView = context;
    }

    @Override
    int getFixedLen() {
        return 16 + this._EStdView.getFixedLen();
    }

    @Override
    int getVarLen() {
        return ERepEntryGetNext.getTotalBytes(this._entryName) + ERepEntryGetNext.getTotalBytes(this._demangledName) + ERepEntryGetNext.getTotalBytes(this._entryReturnType) + super.getVarLen();
    }

    private String getEntryName() {
        if (this._entryName != null) {
            return this._entryName.toString();
        }
        return null;
    }

    private String getDemangledName() {
        if (this._demangledName != null) {
            return this._demangledName.toString();
        }
        return null;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "EntryID", this.getEntryID());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "EntryName", this.getEntryName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "DemangledName", this.getDemangledName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "EntryReturnType", this.getEntryReturnType());
        if (this._EStdView != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, this._EStdView.getDescription());
            this._EStdView.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "EntryContext", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Function entry (" + this.getEntryName() + ")";
    }
}

