/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepContextQualGet
extends EPDC_Reply {
    private int[] _entryIDs = EMPTYINTARRAY;

    ERepContextQualGet(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int numberOfEntries = dataInputStream.readInt();
        if (numberOfEntries == 0) {
            return;
        }
        this._entryIDs = new int[numberOfEntries];
        Throwable throwable = null;
        Object var6_7 = null;
        try (OffsetDataInputStream offsetDataInputStream = new OffsetDataInputStream(byteBuffer, dataInputStream.readInt());){
            int i = 0;
            while (i < numberOfEntries) {
                this._entryIDs[i] = offsetDataInputStream.readInt();
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public int[] getEntryIDs() {
        return this._entryIDs;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        if (this._entryIDs != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Entries", this._entryIDs.length);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Entry_IDs");
            int i = 0;
            while (i < this._entryIDs.length) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Index[" + i + "]", this._entryIDs[i]);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Entries", 0);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Entry_IDs", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Get entries for a context";
    }
}

