/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EBPList;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.ERepProcessStop;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ERepAbstractExecute
extends ERepProcessStop {
    protected ERepAbstractExecute(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._threadID = dataInputStream.readInt();
        this._whyStop = dataInputStream.readShort();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._exceptionMsg = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        int numberOfBreakpointIDs = dataInputStream.readInt();
        this._breakpoints = new EBPList[numberOfBreakpointIDs];
        int i = 0;
        while (i < numberOfBreakpointIDs) {
            this._breakpoints[i] = new EBPList(dataInputStream);
            ++i;
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "DU", this.getThreadID());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "WhyStop", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "Why_.*", this.getWhyStop()));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ExceptionMessage", this.getExceptionMsg());
        EBPList[] bkpts = this.getBreakpoints();
        if (bkpts.length > 0) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "BreakIdList");
            int i = 0;
            while (i < bkpts.length) {
                bkpts[i].writeEPDC(dataOutputStream);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        }
    }
}

