/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_Base;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointClear;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointDisable;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointEnable;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointEntryAutoSet2;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointEvent;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointLocation;
import com.ibm.debug.pdt.internal.epdc.EReqCommandLog;
import com.ibm.debug.pdt.internal.epdc.EReqContextConvert;
import com.ibm.debug.pdt.internal.epdc.EReqContextQualGet;
import com.ibm.debug.pdt.internal.epdc.EReqEntrySearch;
import com.ibm.debug.pdt.internal.epdc.EReqEntryWhere;
import com.ibm.debug.pdt.internal.epdc.EReqExceptionStatusChange;
import com.ibm.debug.pdt.internal.epdc.EReqExecute;
import com.ibm.debug.pdt.internal.epdc.EReqExpression;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionDisable;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionEnable;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionFree;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionNodeAction;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionRepTypeSet;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionSubTree;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionSubTreeDelete;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionValueModify;
import com.ibm.debug.pdt.internal.epdc.EReqGetEventContent;
import com.ibm.debug.pdt.internal.epdc.EReqGetFile;
import com.ibm.debug.pdt.internal.epdc.EReqGetList;
import com.ibm.debug.pdt.internal.epdc.EReqGetNodeExpression;
import com.ibm.debug.pdt.internal.epdc.EReqGlobalList;
import com.ibm.debug.pdt.internal.epdc.EReqGlobalSymbolQuery;
import com.ibm.debug.pdt.internal.epdc.EReqHiddenCommandLog;
import com.ibm.debug.pdt.internal.epdc.EReqInitializeDE;
import com.ibm.debug.pdt.internal.epdc.EReqLocalFilterList;
import com.ibm.debug.pdt.internal.epdc.EReqLocalVariable;
import com.ibm.debug.pdt.internal.epdc.EReqLocalVariableFree;
import com.ibm.debug.pdt.internal.epdc.EReqModuleAdd;
import com.ibm.debug.pdt.internal.epdc.EReqModuleRemove;
import com.ibm.debug.pdt.internal.epdc.EReqModuleSideFileUpdate;
import com.ibm.debug.pdt.internal.epdc.EReqMultiRequest;
import com.ibm.debug.pdt.internal.epdc.EReqPartGet;
import com.ibm.debug.pdt.internal.epdc.EReqPartOpen;
import com.ibm.debug.pdt.internal.epdc.EReqPartSet;
import com.ibm.debug.pdt.internal.epdc.EReqPlayback;
import com.ibm.debug.pdt.internal.epdc.EReqPlaybackControl;
import com.ibm.debug.pdt.internal.epdc.EReqPointerDeref;
import com.ibm.debug.pdt.internal.epdc.EReqPreparePgm;
import com.ibm.debug.pdt.internal.epdc.EReqProcessAttach;
import com.ibm.debug.pdt.internal.epdc.EReqProcessAttach2;
import com.ibm.debug.pdt.internal.epdc.EReqProcessDetach;
import com.ibm.debug.pdt.internal.epdc.EReqProcessDetailsGet;
import com.ibm.debug.pdt.internal.epdc.EReqProcessListGet;
import com.ibm.debug.pdt.internal.epdc.EReqProgramInput;
import com.ibm.debug.pdt.internal.epdc.EReqPutEventContent;
import com.ibm.debug.pdt.internal.epdc.EReqReSync;
import com.ibm.debug.pdt.internal.epdc.EReqRegisters2;
import com.ibm.debug.pdt.internal.epdc.EReqRegistersDetailsGet;
import com.ibm.debug.pdt.internal.epdc.EReqRegistersFree2;
import com.ibm.debug.pdt.internal.epdc.EReqRegistersValueSet;
import com.ibm.debug.pdt.internal.epdc.EReqRemoteHalt;
import com.ibm.debug.pdt.internal.epdc.EReqRepForTypeSet;
import com.ibm.debug.pdt.internal.epdc.EReqSourcePathUpdate;
import com.ibm.debug.pdt.internal.epdc.EReqStack;
import com.ibm.debug.pdt.internal.epdc.EReqStackBuildView;
import com.ibm.debug.pdt.internal.epdc.EReqStackDetailsGet;
import com.ibm.debug.pdt.internal.epdc.EReqStackFree;
import com.ibm.debug.pdt.internal.epdc.EReqStartCC;
import com.ibm.debug.pdt.internal.epdc.EReqStartPgm;
import com.ibm.debug.pdt.internal.epdc.EReqStartTrace2;
import com.ibm.debug.pdt.internal.epdc.EReqStopCC;
import com.ibm.debug.pdt.internal.epdc.EReqStorage2;
import com.ibm.debug.pdt.internal.epdc.EReqStorageConvertToAddress;
import com.ibm.debug.pdt.internal.epdc.EReqStorageFree;
import com.ibm.debug.pdt.internal.epdc.EReqStorageGetBlock;
import com.ibm.debug.pdt.internal.epdc.EReqStoragePutBlock;
import com.ibm.debug.pdt.internal.epdc.EReqStorageUpdate;
import com.ibm.debug.pdt.internal.epdc.EReqStorageUsageCheckSet;
import com.ibm.debug.pdt.internal.epdc.EReqStringFind;
import com.ibm.debug.pdt.internal.epdc.EReqTerminateDE;
import com.ibm.debug.pdt.internal.epdc.EReqTerminatePgm;
import com.ibm.debug.pdt.internal.epdc.EReqThreadFreeze;
import com.ibm.debug.pdt.internal.epdc.EReqThreadInfoGet;
import com.ibm.debug.pdt.internal.epdc.EReqThreadThaw;
import com.ibm.debug.pdt.internal.epdc.EReqTypesNumGet;
import com.ibm.debug.pdt.internal.epdc.EReqUnknown;
import com.ibm.debug.pdt.internal.epdc.EReqVersion;
import com.ibm.debug.pdt.internal.epdc.EReqVersionSecure;
import com.ibm.debug.pdt.internal.epdc.EReqViewFileInfoSet;
import com.ibm.debug.pdt.internal.epdc.EReqViewSearchPath;
import com.ibm.debug.pdt.internal.epdc.EReqViewsVerify;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;

public abstract class EPDC_Request
extends EPDC_Base {
    int _request_code;
    int _threadID;
    private Map<Integer, Object> fProperties = new HashMap<Integer, Object>();
    boolean _immediate = true;
    public boolean _replyReceived = false;
    private boolean fSuppressMsgs = false;
    private EPDC_Reply _reply;
    private TimerTask fTimerTask = null;
    private int fGroupId = 0;

    EPDC_Request(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        this._request_code = dataInputStream.readInt();
        this.setTotalBytes(dataInputStream.readInt());
        if (this.getEPDCVersion() > 310) {
            this._threadID = dataInputStream.readInt();
        }
    }

    EPDC_Request(int request_code, EPDC_EngineSession engineSession) {
        super(engineSession);
        this._request_code = request_code;
        this._threadID = 0;
    }

    EPDC_Request(byte[] byteBuffer, EPDC_EngineSession engineSession) {
        super(byteBuffer, engineSession);
    }

    public static EPDC_Request decodeRequestStream(InputStream inputStream, int totalBytes, EPDC_EngineSession engineSession) throws IOException {
        byte[] bytes = EPDC_Request.getPacket(inputStream, totalBytes);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(bytes));
        dataInputStream.mark(4);
        int reqCode = dataInputStream.readInt();
        dataInputStream.reset();
        switch (reqCode) {
            case 32: {
                return new EReqBreakpointClear(bytes, dataInputStream, engineSession);
            }
            case 33: {
                return new EReqBreakpointDisable(bytes, dataInputStream, engineSession);
            }
            case 34: {
                return new EReqBreakpointEnable(bytes, dataInputStream, engineSession);
            }
            case 35: {
                return new EReqBreakpointEvent(bytes, dataInputStream, engineSession);
            }
            case 1: {
                return new EReqBreakpointLocation(bytes, dataInputStream, engineSession);
            }
            case 44: {
                return new EReqCommandLog(bytes, dataInputStream, engineSession);
            }
            case 50: {
                return new EReqContextConvert(bytes, dataInputStream, engineSession);
            }
            case 211: {
                return new EReqContextQualGet(bytes, dataInputStream, engineSession);
            }
            case 10: {
                return new EReqEntrySearch(bytes, dataInputStream, engineSession);
            }
            case 74: {
                return new EReqExpressionNodeAction(bytes, dataInputStream, engineSession);
            }
            case 232: {
                return new EReqGetNodeExpression(bytes, dataInputStream, engineSession);
            }
            case 43: {
                return new EReqEntryWhere(bytes, dataInputStream, engineSession);
            }
            case 213: {
                return new EReqExceptionStatusChange(bytes, dataInputStream, engineSession);
            }
            case 2: {
                return new EReqExecute(bytes, dataInputStream, engineSession);
            }
            case 3: {
                return new EReqExpression(bytes, dataInputStream, engineSession);
            }
            case 4: {
                return new EReqExpressionDisable(bytes, dataInputStream, engineSession);
            }
            case 5: {
                return new EReqExpressionEnable(bytes, dataInputStream, engineSession);
            }
            case 6: {
                return new EReqExpressionFree(bytes, dataInputStream, engineSession);
            }
            case 39: {
                return new EReqExpressionRepTypeSet(bytes, dataInputStream, engineSession);
            }
            case 37: {
                return new EReqExpressionSubTree(bytes, dataInputStream, engineSession);
            }
            case 38: {
                return new EReqExpressionSubTreeDelete(bytes, dataInputStream, engineSession);
            }
            case 7: {
                return new EReqExpressionValueModify(bytes, dataInputStream, engineSession);
            }
            case 29: {
                return new EReqInitializeDE(bytes, dataInputStream, engineSession);
            }
            case 40: {
                return new EReqLocalVariable(bytes, dataInputStream, engineSession);
            }
            case 41: {
                return new EReqLocalVariableFree(bytes, dataInputStream, engineSession);
            }
            case 8: {
                return new EReqPartGet(bytes, dataInputStream, engineSession);
            }
            case 17: {
                return new EReqPartOpen(bytes, dataInputStream, engineSession);
            }
            case 36: {
                return new EReqPartSet(bytes, dataInputStream, engineSession);
            }
            case 9: {
                return new EReqPointerDeref(bytes, dataInputStream, engineSession);
            }
            case 30: {
                return new EReqPreparePgm(bytes, dataInputStream, engineSession);
            }
            case 46: {
                return new EReqProcessAttach(bytes, dataInputStream, engineSession);
            }
            case 49: {
                return new EReqProcessAttach2(bytes, dataInputStream, engineSession);
            }
            case 47: {
                return new EReqProcessDetach(bytes, dataInputStream, engineSession);
            }
            case 219: {
                return new EReqProcessDetailsGet(bytes, dataInputStream, engineSession);
            }
            case 48: {
                return new EReqProcessListGet(bytes, dataInputStream, engineSession);
            }
            case 210: {
                return new EReqRepForTypeSet(bytes, dataInputStream, engineSession);
            }
            case 13: {
                return new EReqStack(bytes, dataInputStream, engineSession);
            }
            case 15: {
                return new EReqStackBuildView(bytes, dataInputStream, engineSession);
            }
            case 218: {
                return new EReqStackDetailsGet(bytes, dataInputStream, engineSession);
            }
            case 14: {
                return new EReqStackFree(bytes, dataInputStream, engineSession);
            }
            case 31: {
                return new EReqStartPgm(bytes, dataInputStream, engineSession);
            }
            case 24: {
                return new EReqStringFind(bytes, dataInputStream, engineSession);
            }
            case 42: {
                return new EReqTerminateDE(bytes, dataInputStream, engineSession);
            }
            case 25: {
                return new EReqTerminatePgm(bytes, dataInputStream, engineSession);
            }
            case 26: {
                return new EReqThreadFreeze(bytes, dataInputStream, engineSession);
            }
            case 27: {
                return new EReqThreadThaw(bytes, dataInputStream, engineSession);
            }
            case 209: {
                return new EReqTypesNumGet(bytes, dataInputStream, engineSession);
            }
            case 66: {
                return new EReqVersion(bytes, dataInputStream, engineSession);
            }
            case 79: {
                return new EReqVersionSecure(bytes, dataInputStream, engineSession);
            }
            case 67: {
                return new EReqProgramInput(bytes, dataInputStream, engineSession);
            }
            case 28: {
                return new EReqViewsVerify(bytes, dataInputStream, engineSession);
            }
            case 204: {
                return new EReqRemoteHalt(bytes, dataInputStream, engineSession);
            }
            case 227: {
                return new EReqViewSearchPath(bytes, dataInputStream, engineSession);
            }
            case 226: {
                return new EReqViewFileInfoSet(bytes, dataInputStream, engineSession);
            }
            case 214: {
                return new EReqStorageUsageCheckSet(bytes, dataInputStream, engineSession);
            }
            case 18: {
                return new EReqStorage2(bytes, dataInputStream, engineSession);
            }
            case 23: {
                return new EReqStorageUpdate(bytes, dataInputStream, engineSession);
            }
            case 20: {
                return new EReqStorageFree(bytes, dataInputStream, engineSession);
            }
            case 57: {
                return new EReqRegistersValueSet(bytes, dataInputStream, engineSession);
            }
            case 216: {
                return new EReqRegistersDetailsGet(bytes, dataInputStream, engineSession);
            }
            case 54: {
                return new EReqRegisters2(bytes, dataInputStream, engineSession);
            }
            case 56: {
                return new EReqRegistersFree2(bytes, dataInputStream, engineSession);
            }
            case 65: {
                return new EReqThreadInfoGet(bytes, dataInputStream, engineSession);
            }
            case 51: {
                return new EReqBreakpointEntryAutoSet2(bytes, dataInputStream, engineSession);
            }
            case 71: {
                return new EReqStorageGetBlock(bytes, dataInputStream, engineSession);
            }
            case 72: {
                return new EReqStoragePutBlock(bytes, dataInputStream, engineSession);
            }
            case 73: {
                return new EReqStorageConvertToAddress(bytes, dataInputStream, engineSession);
            }
            case 68: {
                return new EReqLocalFilterList(bytes, dataInputStream, engineSession);
            }
            case 70: {
                return new EReqGlobalSymbolQuery(bytes, dataInputStream, engineSession);
            }
            case 69: {
                return new EReqGlobalList(bytes, dataInputStream, engineSession);
            }
            case 231: {
                return new EReqSourcePathUpdate(bytes, dataInputStream, engineSession);
            }
            case 234: {
                return new EReqModuleSideFileUpdate(bytes, dataInputStream, engineSession);
            }
            case 229: {
                return new EReqGetEventContent(bytes, dataInputStream, engineSession);
            }
            case 230: {
                return new EReqPutEventContent(bytes, dataInputStream, engineSession);
            }
            case 77: {
                return new EReqHiddenCommandLog(bytes, dataInputStream, engineSession);
            }
            case 52: {
                return new EReqModuleAdd(bytes, dataInputStream, engineSession);
            }
            case 53: {
                return new EReqModuleRemove(bytes, dataInputStream, engineSession);
            }
            case 233: {
                return new EReqGetList(bytes, dataInputStream, engineSession);
            }
            case 235: {
                return new EReqPlayback(bytes, dataInputStream, engineSession);
            }
            case 236: {
                return new EReqPlaybackControl(bytes, dataInputStream, engineSession);
            }
            case 237: {
                return new EReqStartCC(bytes, dataInputStream, engineSession);
            }
            case 238: {
                return new EReqStopCC(bytes, dataInputStream, engineSession);
            }
            case 240: {
                return new EReqGetFile(bytes, dataInputStream, engineSession);
            }
            case 241: {
                return new EReqMultiRequest(bytes, dataInputStream, engineSession);
            }
            case 78: {
                return new EReqReSync(bytes, dataInputStream, engineSession);
            }
            case 242: {
                return new EReqStartTrace2(bytes, dataInputStream, engineSession);
            }
        }
        return new EReqUnknown(bytes, dataInputStream, engineSession);
    }

    public final void send(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(this.getTotalBytes());
        if (this.getEPDCEngineSession().isEPDCDumpEnabled()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(this.getTotalBytes());
            DataOutputStream dos = new DataOutputStream(bos);
            this.output(dos);
            EPDC_Base.dumpEPDC(bos.toByteArray(), this.getEPDCEngineSession(), (byte)0);
            dataOutputStream.write(bos.toByteArray());
        } else {
            this.output(dataOutputStream);
        }
        dataOutputStream.flush();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this._request_code);
        dataOutputStream.writeInt(this.getTotalBytes());
        if (this.getEPDCVersion() > 310) {
            dataOutputStream.writeInt(this._threadID);
        }
    }

    @Override
    int getFixedLen() {
        if (this.getEPDCVersion() > 310) {
            return 12;
        }
        return 8;
    }

    @Override
    int getVarLen() {
        return 0;
    }

    public final int getRequestCode() {
        return this._request_code;
    }

    public boolean isImmediate() {
        if (this.getEPDCEngineSession().supportsAsync()) {
            return true;
        }
        return this._immediate;
    }

    public void suppressMsgs() {
        this.fSuppressMsgs = true;
    }

    public boolean isSuppressMsgs() {
        return this.fSuppressMsgs;
    }

    public boolean isValidAfterProgramTerminate() {
        return false;
    }

    public boolean isProgramStarting() {
        return this._request_code == 30 || this._request_code == 46 || this._request_code == 49;
    }

    public boolean isProgramTerminating() {
        return (this._request_code == 25 || this._request_code == 47) && this.getReply() != null && this.getReply().getReturnCode() == 0;
    }

    public void setThreadID(int threadID) {
        this._threadID = threadID;
    }

    public void putProperty(EProperty property) {
        if (property == null) {
            return;
        }
        this.fProperties.put(property.getKey(), property.getObject());
    }

    Object retrieveObject(int key) {
        if (this.fProperties.containsKey(key)) {
            Object obj = this.fProperties.get(key);
            this.fProperties.remove(key);
            return obj;
        }
        return null;
    }

    boolean contains(int key) {
        return this.fProperties.containsKey(key);
    }

    Map<Integer, Object> getProperties() {
        HashMap<Integer, Object> temp = new HashMap<Integer, Object>();
        temp.putAll(this.fProperties);
        this.fProperties.clear();
        return temp;
    }

    public EPDC_Reply getReply() {
        return this._reply;
    }

    public void setReply(EPDC_Reply reply) {
        this._reply = reply;
    }

    public TimerTask getTimerTask() {
        return this.fTimerTask;
    }

    public void setTimerTask(TimerTask timerTask) {
        this.fTimerTask = timerTask;
    }

    public boolean isMatchingReply(EPDC_Reply reply) {
        return this.getRequestCode() == reply.getReplyCode();
    }

    @Override
    public final void writeFormattedEPDC(DataOutputStream dataOutputStream, boolean dumpHex) throws IOException {
        EPDC_DumpUtils.beginPacket(dataOutputStream, this);
        EPDC_DumpUtils.startHeader(dataOutputStream);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "request_code", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "Remote_.*", this._request_code));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "length", this.getTotalBytes());
        if (this.getEPDCVersion() > 310) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "threadID", this._threadID);
        }
        EPDC_DumpUtils.endHeader(dataOutputStream);
        this.writeEPDC(dataOutputStream);
        if (dumpHex) {
            EPDC_DumpUtils.writeBytes(dataOutputStream, String.format("Hex dump: Length = %1$d,0x%1$02X", this.getByteBuffer().length), this.getByteBuffer(), 0);
        }
        EPDC_DumpUtils.endPacket(dataOutputStream);
    }

    @Override
    public String getPacketType() {
        return "Request";
    }

    @Override
    public String toString() {
        return this.getDescription() + " (" + this._request_code + ")";
    }

    public int getGroupId() {
        return this.fGroupId;
    }

    public void setGroupId(int groupId) {
        this.fGroupId = groupId;
    }

    EStdString initViewOrderRequest(int[] viewOrder, EPDC_EngineSession engineSession) {
        if (viewOrder != null && viewOrder.length != 0) {
            engineSession.setRequestedViewOrder(viewOrder);
            StringBuilder sb = new StringBuilder();
            int[] nArray = viewOrder;
            int n = viewOrder.length;
            int n2 = 0;
            while (n2 < n) {
                int view = nArray[n2];
                sb.append(view).append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
            return new EStdString(sb.toString(), this.getEPDCEngineSession());
        }
        return null;
    }

    public boolean isCancelOnTimeout() {
        return false;
    }

    public static class EProperty {
        static final EProperty[] EMPTYPROPERTIES = new EProperty[0];
        private int fKey;
        private Object fObject;

        public EProperty(int key, Object object) {
            this.fKey = key;
            this.fObject = object;
        }

        public int getKey() {
            return this.fKey;
        }

        public Object getObject() {
            return this.fObject;
        }
    }
}

