/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPBreakpoint;
import com.ibm.debug.pdt.internal.epdc.ECPCC;
import com.ibm.debug.pdt.internal.epdc.ECPFCT;
import com.ibm.debug.pdt.internal.epdc.ECPLog;
import com.ibm.debug.pdt.internal.epdc.ECPModule;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExprBase;
import com.ibm.debug.pdt.internal.epdc.ECPPart;
import com.ibm.debug.pdt.internal.epdc.ECPRegister;
import com.ibm.debug.pdt.internal.epdc.ECPStack;
import com.ibm.debug.pdt.internal.epdc.ECPStorage;
import com.ibm.debug.pdt.internal.epdc.ECPThread;
import com.ibm.debug.pdt.internal.epdc.ECPTrace;
import com.ibm.debug.pdt.internal.epdc.EPDCUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_Base;
import com.ibm.debug.pdt.internal.epdc.EPDC_BasicReply;
import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_ChangePacket;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepBreakpointLocation;
import com.ibm.debug.pdt.internal.epdc.ERepCommandLog;
import com.ibm.debug.pdt.internal.epdc.ERepContextConvert;
import com.ibm.debug.pdt.internal.epdc.ERepContextQualGet;
import com.ibm.debug.pdt.internal.epdc.ERepEngineFailure;
import com.ibm.debug.pdt.internal.epdc.ERepEntrySearch;
import com.ibm.debug.pdt.internal.epdc.ERepEntryWhere;
import com.ibm.debug.pdt.internal.epdc.ERepExecute;
import com.ibm.debug.pdt.internal.epdc.ERepGetEventContent;
import com.ibm.debug.pdt.internal.epdc.ERepGetFile;
import com.ibm.debug.pdt.internal.epdc.ERepGetList;
import com.ibm.debug.pdt.internal.epdc.ERepGetNodeExpression;
import com.ibm.debug.pdt.internal.epdc.ERepGlobalList;
import com.ibm.debug.pdt.internal.epdc.ERepGlobalSymbolQuery;
import com.ibm.debug.pdt.internal.epdc.ERepInitializeDE;
import com.ibm.debug.pdt.internal.epdc.ERepJobsListGet;
import com.ibm.debug.pdt.internal.epdc.ERepLocalFilterList;
import com.ibm.debug.pdt.internal.epdc.ERepMultiRequest;
import com.ibm.debug.pdt.internal.epdc.ERepNotify;
import com.ibm.debug.pdt.internal.epdc.ERepPartGet;
import com.ibm.debug.pdt.internal.epdc.ERepPartOpen;
import com.ibm.debug.pdt.internal.epdc.ERepPlayback;
import com.ibm.debug.pdt.internal.epdc.ERepPlaybackControl;
import com.ibm.debug.pdt.internal.epdc.ERepPreparePgm;
import com.ibm.debug.pdt.internal.epdc.ERepProcessAttach;
import com.ibm.debug.pdt.internal.epdc.ERepProcessDetach;
import com.ibm.debug.pdt.internal.epdc.ERepProcessDetailsGet;
import com.ibm.debug.pdt.internal.epdc.ERepProcessListGet;
import com.ibm.debug.pdt.internal.epdc.ERepProcessStop;
import com.ibm.debug.pdt.internal.epdc.ERepPutEventContent;
import com.ibm.debug.pdt.internal.epdc.ERepReSync;
import com.ibm.debug.pdt.internal.epdc.ERepRegistersDetailsGet;
import com.ibm.debug.pdt.internal.epdc.ERepSourcePathUpdate;
import com.ibm.debug.pdt.internal.epdc.ERepStackBuildView;
import com.ibm.debug.pdt.internal.epdc.ERepStackDetailsGet;
import com.ibm.debug.pdt.internal.epdc.ERepStartCC;
import com.ibm.debug.pdt.internal.epdc.ERepStartPgm;
import com.ibm.debug.pdt.internal.epdc.ERepStartTrace2;
import com.ibm.debug.pdt.internal.epdc.ERepStorageConvertToAddress;
import com.ibm.debug.pdt.internal.epdc.ERepStorageGetBlock;
import com.ibm.debug.pdt.internal.epdc.ERepStringFind;
import com.ibm.debug.pdt.internal.epdc.ERepTypesNumGet;
import com.ibm.debug.pdt.internal.epdc.ERepVersion;
import com.ibm.debug.pdt.internal.epdc.ERepVersionSecure;
import com.ibm.debug.pdt.internal.epdc.ERepViewSearchPath;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.IMultiRequest;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public abstract class EPDC_Reply
extends EPDC_Base {
    private EPDC_Request _request = null;
    protected int _reply_code;
    protected int _return_code;
    private int _changed_info;
    protected EStdString _message_text;
    private String fMessageText = null;
    private boolean fMessageTextProcessed = false;
    public boolean _processed = false;
    protected short fEventCode = 0;
    private ArrayList<ECPPart> fPartChanges;
    private ArrayList<ECPBreakpoint> fBkptChanges;
    private ArrayList<ECPThread> fThreadChanges;
    private ArrayList<ECPMonitorExprBase> fMonitorChanges;
    private ArrayList<ECPStorage> fStorageChanges;
    private ArrayList<ECPStack> fStackChanges;
    private ArrayList<ECPModule> fModuleChanges;
    private ArrayList<ECPRegister> fRegisterChanges;
    private ArrayList<ECPFCT> FFCTChanges;
    private ArrayList<ECPLog> fLogChanges;
    private ArrayList<ECPCC> fCCChanges;
    private ArrayList<ECPTrace> fTraceChanges;
    private EPDC_Request fMultiParent;

    EPDC_Reply(EPDC_EngineSession engineSession) {
        super(engineSession);
    }

    EPDC_Reply(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        this._reply_code = dataInputStream.readInt();
        this._return_code = dataInputStream.readInt();
        if (this._return_code == 333) {
            this.fEventCode = (short)333;
            this._return_code = 0;
        }
        this._changed_info = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._message_text = new EStdString(new OffsetDataInputStream(byteBuffer, offset), this.getEPDCEngineSession());
        }
        if (this.fEventCode > 0) {
            this._message_text = null;
        }
        if (4 != dataInputStream.skipBytes(4)) {
            PDTCoreUtils.logString(this, "Unable to read all reserved bytes.", 4);
        }
        this.setTotalBytes(dataInputStream.readInt());
    }

    EPDC_Reply(byte[] byteBuffer, EPDC_EngineSession engineSession) {
        super(byteBuffer, engineSession);
    }

    public static EPDC_Reply decodeReplyStream(InputStream inputStream, int totalBytes, EPDC_EngineSession engineSession, boolean processChgPkts) throws IOException {
        return EPDC_Reply.decodeReplyStream(inputStream, totalBytes, engineSession, processChgPkts, true);
    }

    public static EPDC_Reply decodeReplyStream(InputStream inputStream, int totalBytes, EPDC_EngineSession engineSession, boolean processChgPkts, boolean dump) throws IOException {
        byte[] packetByteArray = EPDC_Reply.getPacket(inputStream, totalBytes);
        if (engineSession.isEPDCDumpEnabled() && dump) {
            EPDC_Base.dumpEPDC(packetByteArray, engineSession, (byte)1);
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(packetByteArray));
        dataInputStream.mark(4);
        int replyCode = dataInputStream.readInt();
        dataInputStream.reset();
        EPDC_Reply reply = null;
        switch (replyCode) {
            case 29: {
                reply = new ERepInitializeDE(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 78: {
                reply = new ERepReSync(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 30: {
                reply = new ERepPreparePgm(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 31: {
                reply = new ERepStartPgm(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 46: 
            case 49: {
                reply = new ERepProcessAttach(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 47: {
                reply = new ERepProcessDetach(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 8: {
                reply = new ERepPartGet(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 2: {
                reply = new ERepExecute(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 10: {
                reply = new ERepEntrySearch(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 218: {
                reply = new ERepStackDetailsGet(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 15: {
                reply = new ERepStackBuildView(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 50: {
                reply = new ERepContextConvert(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 211: {
                reply = new ERepContextQualGet(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 216: {
                reply = new ERepRegistersDetailsGet(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 209: {
                reply = new ERepTypesNumGet(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 24: {
                reply = new ERepStringFind(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 66: {
                reply = new ERepVersion(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 79: {
                reply = new ERepVersionSecure(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 219: {
                reply = new ERepProcessDetailsGet(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 48: {
                reply = new ERepProcessListGet(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 17: {
                reply = new ERepPartOpen(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 1: {
                reply = new ERepBreakpointLocation(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 43: {
                reply = new ERepEntryWhere(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 227: {
                reply = new ERepViewSearchPath(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 215: {
                reply = new ERepJobsListGet(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 229: {
                reply = new ERepGetEventContent(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 230: {
                reply = new ERepPutEventContent(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 44: 
            case 77: {
                reply = new ERepCommandLog(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 70: {
                reply = new ERepGlobalSymbolQuery(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 68: {
                reply = new ERepLocalFilterList(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 69: {
                reply = new ERepGlobalList(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 73: {
                reply = new ERepStorageConvertToAddress(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 71: {
                reply = new ERepStorageGetBlock(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 232: {
                reply = new ERepGetNodeExpression(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 231: {
                reply = new ERepSourcePathUpdate(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 999: {
                reply = new ERepEngineFailure(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 76: {
                reply = new ERepNotify(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 233: {
                reply = new ERepGetList(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 235: {
                reply = new ERepPlayback(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 236: {
                reply = new ERepPlaybackControl(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 237: {
                reply = new ERepStartCC(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 240: {
                reply = new ERepGetFile(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 241: {
                reply = new ERepMultiRequest(packetByteArray, dataInputStream, engineSession);
                break;
            }
            case 242: {
                reply = new ERepStartTrace2(packetByteArray, dataInputStream, engineSession);
                break;
            }
            default: {
                reply = new EPDC_BasicReply(packetByteArray, dataInputStream, engineSession);
            }
        }
        if (processChgPkts) {
            int minChgPacketsExpected = reply.getNumUniqueChangePacketTypes();
            int i = 0;
            while (i < minChgPacketsExpected) {
                EPDC_ChangePacket chgPkt;
                int recvdItems = 0;
                int totalItems = 0;
                do {
                    chgPkt = EPDC_ChangePacket.decodeChangePacketStream(inputStream, 0, reply, engineSession);
                    totalItems = chgPkt.getTotalChgItems();
                } while ((recvdItems += chgPkt.getNumChgItems()) < totalItems);
                ++i;
            }
        }
        return reply;
    }

    public int getReplyCode() {
        return this._reply_code;
    }

    public int getReturnCode() {
        return this._return_code;
    }

    public String getMessageText() {
        if (!this.fMessageTextProcessed) {
            this.fMessageTextProcessed = true;
            if (this._message_text != null && this._message_text.length() > 0) {
                this.fMessageText = this._message_text.toString();
                if (!this.isError() && this.isMsgIDCheckSupported() && !EPDCUtils.isValidMessageID(this.fMessageText)) {
                    String hashString = String.valueOf(this.fMessageText.hashCode());
                    if (hashString.startsWith("-")) {
                        hashString = hashString.substring(1);
                    }
                    if (hashString.length() > 4) {
                        hashString = hashString.substring(hashString.length() - 4);
                    }
                    this.fMessageText = String.format("PDT%04dI %s", Integer.parseInt(hashString), this.fMessageText);
                }
            }
        }
        return this.fMessageText;
    }

    private boolean isMsgIDCheckSupported() {
        return this.getEPDCEngineSession().isDebugTool() || this.getEPDCEngineSession().isiSeriesEngine() || this.getEPDCEngineSession().isPICL();
    }

    public ECPFCT[] getFCTChanges() {
        if (this.FFCTChanges == null) {
            return ECPFCT.EMPTY;
        }
        return this.FFCTChanges.toArray(new ECPFCT[this.FFCTChanges.size()]);
    }

    public ECPStorage[] getStorageChanges() {
        if (this.fStorageChanges == null) {
            return ECPStorage.EMPTY;
        }
        return this.fStorageChanges.toArray(new ECPStorage[this.fStorageChanges.size()]);
    }

    public ECPModule[] getModuleChanges() {
        if (this.fModuleChanges == null) {
            return ECPModule.EMPTY;
        }
        return this.fModuleChanges.toArray(new ECPModule[this.fModuleChanges.size()]);
    }

    public ECPThread[] getThreadChanges() {
        if (this.fThreadChanges == null) {
            return ECPThread.EMPTY;
        }
        return this.fThreadChanges.toArray(new ECPThread[this.fThreadChanges.size()]);
    }

    public ECPPart[] getPartChanges() {
        if (this.fPartChanges == null) {
            return ECPPart.EMPTY;
        }
        return this.fPartChanges.toArray(new ECPPart[this.fPartChanges.size()]);
    }

    public ECPBreakpoint[] getBreakpointChanges() {
        if (this.fBkptChanges == null) {
            return ECPBreakpoint.EMPTY;
        }
        return this.fBkptChanges.toArray(new ECPBreakpoint[this.fBkptChanges.size()]);
    }

    public ECPMonitorExprBase[] getMonitorChanges() {
        if (this.fMonitorChanges == null) {
            return ECPMonitorExprBase.EMPTY;
        }
        return this.fMonitorChanges.toArray(new ECPMonitorExprBase[this.fMonitorChanges.size()]);
    }

    public ECPStack[] getStackChanges() {
        if (this.fStackChanges == null) {
            return ECPStack.EMPTY;
        }
        return this.fStackChanges.toArray(new ECPStack[this.fStackChanges.size()]);
    }

    public ECPRegister[] getRegisterChanges() {
        if (this.fRegisterChanges == null) {
            return ECPRegister.EMPTY;
        }
        return this.fRegisterChanges.toArray(new ECPRegister[this.fRegisterChanges.size()]);
    }

    public ECPLog[] getLogChanges() {
        if (this.fLogChanges == null) {
            return ECPLog.EMPTY;
        }
        return this.fLogChanges.toArray(new ECPLog[this.fLogChanges.size()]);
    }

    public ECPCC[] getCCChanges() {
        if (this.fCCChanges == null) {
            return ECPCC.EMPTY;
        }
        return this.fCCChanges.toArray(new ECPCC[this.fCCChanges.size()]);
    }

    public ECPTrace[] getTraceChanges() {
        if (this.fTraceChanges == null) {
            return ECPTrace.EMPTY;
        }
        return this.fTraceChanges.toArray(new ECPTrace[this.fTraceChanges.size()]);
    }

    void add(EPDC_ChangeItem chgPkt) {
        switch (chgPkt.getPacketID()) {
            case 1: {
                if (this.fPartChanges == null) {
                    this.fPartChanges = new ArrayList();
                }
                this.fPartChanges.add((ECPPart)chgPkt);
                break;
            }
            case 2: {
                if (this.fBkptChanges == null) {
                    this.fBkptChanges = new ArrayList();
                }
                this.fBkptChanges.add((ECPBreakpoint)chgPkt);
                break;
            }
            case 3: {
                if (this.fThreadChanges == null) {
                    this.fThreadChanges = new ArrayList();
                }
                this.fThreadChanges.add((ECPThread)chgPkt);
                break;
            }
            case 4: {
                if (this.fMonitorChanges == null) {
                    this.fMonitorChanges = new ArrayList();
                }
                this.fMonitorChanges.add((ECPMonitorExprBase)chgPkt);
                break;
            }
            case 9: {
                if (this.fStorageChanges == null) {
                    this.fStorageChanges = new ArrayList();
                }
                this.fStorageChanges.add((ECPStorage)chgPkt);
                break;
            }
            case 10: {
                if (this.fStackChanges == null) {
                    this.fStackChanges = new ArrayList();
                }
                this.fStackChanges.add((ECPStack)chgPkt);
                break;
            }
            case 12: {
                if (this.fModuleChanges == null) {
                    this.fModuleChanges = new ArrayList();
                }
                this.fModuleChanges.add((ECPModule)chgPkt);
                break;
            }
            case 13: {
                if (this.fLogChanges == null) {
                    this.fLogChanges = new ArrayList();
                }
                this.fLogChanges.add((ECPLog)chgPkt);
                break;
            }
            case 14: {
                if (this.fRegisterChanges == null) {
                    this.fRegisterChanges = new ArrayList();
                }
                this.fRegisterChanges.add((ECPRegister)chgPkt);
                break;
            }
            case 17: {
                if (this.FFCTChanges == null) {
                    this.FFCTChanges = new ArrayList();
                }
                this.FFCTChanges.add((ECPFCT)chgPkt);
                break;
            }
            case 18: {
                if (this.fCCChanges == null) {
                    this.fCCChanges = new ArrayList();
                }
                this.fCCChanges.add((ECPCC)chgPkt);
                break;
            }
            case 19: {
                if (this.fTraceChanges == null) {
                    this.fTraceChanges = new ArrayList();
                }
                this.fTraceChanges.add((ECPTrace)chgPkt);
                break;
            }
        }
    }

    public boolean hasChangePackets() {
        return this._changed_info != 0;
    }

    public boolean isPartChgd() {
        return (this._changed_info & Integer.MIN_VALUE) != 0;
    }

    public boolean isBrkPtChgd() {
        return (this._changed_info & 0x40000000) != 0;
    }

    public boolean isThreadStateChgd() {
        return (this._changed_info & 0x20000000) != 0;
    }

    public boolean isMonVariableChgd() {
        return (this._changed_info & 0x10000000) != 0;
    }

    public boolean isMonStorChgd() {
        return (this._changed_info & 0x800000) != 0;
    }

    public boolean isMonStackChgd() {
        return (this._changed_info & 0x400000) != 0;
    }

    public boolean isMonRegsChgd() {
        return (this._changed_info & 0x40000) != 0;
    }

    public boolean isModuleEntryChgd() {
        return (this._changed_info & 0x100000) != 0;
    }

    public boolean isFCTChgd() {
        return (this._changed_info & 0x8000) != 0;
    }

    public boolean isLogChgd() {
        return (this._changed_info & 0x4000) != 0;
    }

    public boolean isCCChgd() {
        return (this._changed_info & 0x2000) != 0;
    }

    public boolean isTraceChgd() {
        return (this._changed_info & 0x1000) != 0;
    }

    @Override
    public final void writeFormattedEPDC(DataOutputStream dataOutputStream, boolean dumpHex) throws IOException {
        EPDC_DumpUtils.NameVal[] chngInfoConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(0, "Nothing changed"), new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "Parts"), new EPDC_DumpUtils.NameVal(0x40000000, "Breakpoints"), new EPDC_DumpUtils.NameVal(0x20000000, "Threads"), new EPDC_DumpUtils.NameVal(0x10000000, "Variables"), new EPDC_DumpUtils.NameVal(0x800000, "Storage"), new EPDC_DumpUtils.NameVal(0x400000, "Stack/stackframes"), new EPDC_DumpUtils.NameVal(0x100000, "Modules"), new EPDC_DumpUtils.NameVal(262144, "Registers"), new EPDC_DumpUtils.NameVal(32768, "FCT bits"), new EPDC_DumpUtils.NameVal(16384, "Logs"), new EPDC_DumpUtils.NameVal(8192, "Code Coverage"), new EPDC_DumpUtils.NameVal(4096, "Trace")};
        EPDC_DumpUtils.beginPacket(dataOutputStream, this);
        EPDC_DumpUtils.startHeader(dataOutputStream);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "reply_type", this.getDescription());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "reply_code", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "Remote_.*", this._reply_code));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "length", this.getTotalBytes());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "return_code", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "ExecRc_.*", this.getReturnCode()));
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Change packets returned", this._changed_info, chngInfoConstants);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Engine message", this.getMessageText());
        EPDC_DumpUtils.endHeader(dataOutputStream);
        if (!(this instanceof EPDC_BasicReply)) {
            this.writeEPDC(dataOutputStream);
        }
        if (dumpHex) {
            EPDC_DumpUtils.writeBytes(dataOutputStream, String.format("Hex dump: Length = %1$d,0x%1$02X", this.getByteBuffer().length), this.getByteBuffer(), 0);
        }
        EPDC_DumpUtils.endPacket(dataOutputStream);
    }

    private int getNumUniqueChangePacketTypes() {
        if (this._changed_info == 0) {
            return 0;
        }
        int numberOfChangePackets = 0;
        int i = 1;
        while (i != 0) {
            if ((this._changed_info & i) != 0) {
                ++numberOfChangePackets;
            }
            i <<= 1;
        }
        return numberOfChangePackets;
    }

    @Override
    final int getFixedLen() {
        return 0;
    }

    @Override
    final int getVarLen() {
        return 0;
    }

    @Override
    final void output(DataOutputStream dataOutputStream) throws IOException {
    }

    public void setRequest(EPDC_Request request) {
        this._request = request;
    }

    public EPDC_Request getRequest() {
        return this._request;
    }

    public Object retrieveObject(int key) {
        if (this._request != null) {
            if (!this._request.contains(key)) {
                if (PDTCorePlugin.fModelEPDC) {
                    PDTCoreUtils.logString(this, "Missing request property key " + key, 2);
                }
            } else {
                return this._request.retrieveObject(key);
            }
        }
        return null;
    }

    public Map<Integer, Object> getProperties() {
        if (this._request == null) {
            return Collections.emptyMap();
        }
        return this._request.getProperties();
    }

    public boolean isProgramTerminating() {
        if (this instanceof ERepProcessStop) {
            return ((ERepProcessStop)this).getStopInfo().isEnded();
        }
        return false;
    }

    public short getEventCode() {
        return this.fEventCode;
    }

    @Override
    public String getPacketType() {
        return "Reply";
    }

    @Override
    public String toString() {
        return this.getDescription() + " (" + this._reply_code + ")";
    }

    protected boolean isError() {
        return this._return_code != 0;
    }

    public EPDC_Request getMultiRequestParent() {
        if (this.fMultiParent == null && this._request != null && this._request.contains(20180713)) {
            Object parent = this._request.retrieveObject(20180713);
            if (parent instanceof IMultiRequest && parent instanceof EPDC_Request) {
                this.fMultiParent = (EPDC_Request)parent;
            } else {
                this._request.putProperty(new EPDC_Request.EProperty(20180713, parent));
            }
        }
        return this.fMultiParent;
    }
}

