/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.core.IEPDCFormatter2;
import com.ibm.debug.pdt.core.IEPDCFormatter3;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.epdc.IFormattedString;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.breakpoints.BreakpointFactory;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EFunctCustTable;
import com.ibm.debug.pdt.internal.epdc.EPDCDumpThread;
import com.ibm.debug.pdt.internal.epdc.ERepGetExceptions;
import com.ibm.debug.pdt.internal.epdc.ERepGetLanguages;
import com.ibm.debug.pdt.internal.epdc.ERepGetMacroGroups;
import com.ibm.debug.pdt.internal.epdc.ERepGetPlaybackOptions;
import com.ibm.debug.pdt.internal.epdc.ERepGetViews;
import com.ibm.debug.pdt.internal.epdc.ERepTypesNumGet;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class EPDC_EngineSession {
    protected int _engineID;
    protected String _engineLabel;
    protected String _engineVersionString;
    protected String _OSVersionString;
    protected byte _engineHardware;
    protected byte _engineOS;
    private String _engineKey;
    protected int _defaultSettings;
    protected int _processDetachAction;
    protected ERepGetViews[] fViewInfos;
    protected int fNumberViews;
    protected ERepGetLanguages[] _languageInfo;
    protected ERepGetExceptions[] _exceptionsInfo;
    private static final String[] EMPTYSTRINGS = new String[0];
    protected ERepGetMacroGroups _macroGroups;
    private EFunctCustTable _functCustomTable;
    protected String[] _repNames;
    public static final Object fFormatterLock = new Object();
    public String[] _ThreadStateLabels = new String[]{PICLLabels.Thread_State_0, PICLLabels.Thread_State_1, PICLLabels.Thread_State_2, PICLLabels.Thread_State_3, PICLLabels.Thread_State_4};
    public String _ThreadNameLabel = PICLLabels.Thread_Name;
    public String _ThreadStateLabel = PICLLabels.Thread_State;
    public String _ThreadPriorityLabel = PICLLabels.Thread_Priority;
    public String _ThreadGroupLabel = PICLLabels.Thread_Group;
    public String _ThreadBlockingThreadLabel = PICLLabels.Thread_ThreadBlockingThread;
    protected ERepTypesNumGet _repInfo;
    private int _negotiatedEPDCVersion;
    private String _EngineExtensionID;
    private IFormattedString _FormattingClass = null;
    private static IEPDCFormatter2[] fEPDCFormatters = null;
    private static final IEPDCFormatter2[] EMPTYFORMATTERS = new IEPDCFormatter2[0];
    private boolean fEPDCDumpEnabled = false;
    private long _DumpStartTime = 0L;
    private LinkedList<byte[]> fEPDCDumpList = null;
    protected ERepGetPlaybackOptions[] fPlaybackOptions;
    private boolean _is390 = false;
    private boolean _is390OS = false;
    private boolean _isDebugTool = false;
    private boolean _isSLD = false;
    private boolean _iszPICL = false;
    private boolean _isIntel = false;
    private boolean _isiSeriesEngine = false;
    private boolean _isiSeriesOS = false;
    private boolean _isTPFengine = false;
    private boolean _iszTPFengine = false;
    private boolean _isDBXengine = false;
    private boolean _useStackEntry = false;
    private boolean _reverseStackEntries = false;
    private boolean _isAIX = false;
    private boolean _isPICL = false;
    private int[] fRequestedViewOrder = null;
    private boolean fAuthenticateConnection = false;
    private String fUserId;
    private char[] fPassword;
    private boolean _fct_supportsDebugInitialization;
    private boolean _fct_supportsJobName;
    private boolean _fct_supportsProgramList;
    private boolean _fct_supportsHostAddress;
    private boolean _fct_forceLicenseCheck;
    private boolean _fct_viewOrder;
    private boolean _fct_supportsMultipleThreads;
    private boolean _fct_supportsTerminateType;
    private boolean _fct_supportsForkFollowBoth;
    private boolean _fct_supportsChildProcesses;
    private boolean _fct_supportsIncludeFiles;
    private boolean _fct_supportsDebugOnDemand;
    private boolean _fct_supportsStartup;
    private boolean _fct_supportsProcessListStartup;
    private boolean _fct_supportsPostMortemDebug;
    private boolean _fct_supportsPostMortemCapable;
    private boolean _fct_supportsEnhancedStorage;
    private boolean _fct_supportsAsync;
    private boolean _fct_supportsGetList;
    private boolean _fct_supportsTeamDebug;
    private boolean _fct_supportsMultipleBreakpointRequests;
    private boolean _fct_supportsMultipleRequests;
    private boolean _fct_supportsEventContent;
    private boolean _fct_supportsplayback;
    private boolean _fct_supportsEnhancedCC;
    private boolean _fct_supportsMixedCC;
    private boolean _fct_supportsMixedCCSwitchView;
    private boolean _fct_supportsTrace;
    private boolean _fct_supportsChangeSourceFile;
    private boolean _fct_supportsRestart;
    private boolean _fct_supportsModuleAdd;
    private boolean _fct_supportsModuleRemove;
    private boolean _fct_supportsProcessAttach;
    private boolean _fct_supportsProcessDetach;
    private boolean _fct_supportsProcessDetachKill;
    private boolean _fct_supportsProcessDetachKeep;
    private boolean _fct_supportsProcessDetachRelease;
    private boolean _fct_supportsLocalSourceFiles;
    private boolean _fct_supportsSearchLocalFirst;
    private boolean _fct_supportsUpdateEngineSearchPath;
    private boolean _fct_supportsModuleSideFileUpdate;
    private boolean _fct_supportsLineBreakpoints;
    private boolean _fct_supportsStatementBreakpoints;
    private boolean _fct_supportsFunctionBreakpoints;
    private boolean _fct_supportsAddressBreakpoints;
    private boolean _fct_supportsChangeAddrBreakpoints;
    private boolean _fct_supportsLoadBreakpoints;
    private boolean _fct_supportsOccurrenceBreakpoints;
    private boolean _fct_supportsEnableDisableBreakpoints;
    private boolean _fct_supportsModifyingBreakpoints;
    private boolean _fct_supportsDeferredBreakpoints;
    private boolean _fct_supportsEntryAutoSet;
    private boolean _fct_supportsExpressionOnConditionalBkp;
    private boolean _fct_supportsAddrBkpMonitor_8Bytes;
    private boolean _fct_supportsAddrBkpMonitor_4Bytes;
    private boolean _fct_supportsAddrBkpMonitor_2Bytes;
    private boolean _fct_supportsAddrBkpMonitor_1Bytes;
    private boolean _fct_supportsAddrBkpMonitor_0_128Bytes;
    private boolean _fct_supportsAddrBkpMonitor_Auto;
    private boolean _fct_supportsDateBreakpoints;
    private boolean _fct_supportsThreadOnConditionalBkp;
    private boolean _fct_supportsFreqOnConditionalBkp;
    private boolean _fct_supportsAmbiguousBreakpoints;
    private boolean _fct_supportsAmbiguousAllBreakpoints;
    private boolean _fct_supportsEngineBreakpoints;
    private boolean _fct_supportsChgAddrContionalBkp;
    private boolean _fct_supportsThreadSpecificOnlyBreakpoints;
    private boolean _fct_supportsBreakpointActions;
    private boolean _fct_supportsMacroBreakpoints;
    private boolean _fct_supportsMacroGroupBreakpoints;
    private boolean _fct_supportsEnahancedWatchpointBreakpoints;
    private boolean _fct_supportsBreakpointSyncAsyncStopControl;
    private boolean _fct_supportsSourceEntryBreakpoint;
    private boolean _fct_supportsAddressRangeBreakpoints;
    private boolean _fct_supportsZeroAddressBreakpoints;
    private boolean _fct_supportsEnableDisableMonitors;
    private boolean _fct_supportsMonitorAnyLocals;
    private boolean _fct_supportsLocalFilters;
    private boolean _fct_supportsMonitorGlobalList;
    private boolean _fct_supportsMonitorGlobalSymbols;
    private boolean _fct_supportsMonitoringExpressions;
    private boolean _fct_supportsNewMonitorFormat;
    private boolean _fct_supportsGetNodeExpression;
    private boolean _fct_supportsLocalVariables;
    private boolean _fct_supportsRegisters;
    private boolean _fct_supportsStack;
    private boolean _fct_supportsStorage;
    private boolean _fct_supportsCommandLog;
    private boolean _fct_supportsHiddenCommandLog;
    private boolean _fct_supportsProgramIO;
    private boolean _fct_supportsModules;
    private boolean _fct_supportsThreadFreezeThaw;
    private boolean _fct_supportsStepOver;
    private boolean _fct_supportsStepInto;
    private boolean _fct_supportsStepDebug;
    private boolean _fct_supportsStepReturn;
    private boolean _fct_supportsRunToLocation;
    private boolean _fct_supportsJumpToLocation;
    private boolean _fct_supportsHalt;
    private boolean _fct_supportsStorageUsageCheck;
    private boolean _fct_supportsRunToEntry;
    private boolean _fct_supportsSkipNext;
    private boolean _fct_supportsExceptionFiltering;
    private boolean _fct_supportsExceptionExamine;
    private boolean _fct_supportsExceptionStep;
    private boolean _fct_supportsExceptionRun;
    private boolean _fct_supportsRememberForkChoice;
    private int fConnectionTimeout = 0;
    private byte fTerminateType = 0;
    private boolean fBrkptSuspendAllThreads = false;
    private String fGlobalEnginePath = null;
    private BreakpointFactory fBreakpointFactory = new BreakpointFactory();

    public boolean isEPDCDumpEnabled() {
        return this.fEPDCDumpEnabled;
    }

    public byte getTerminateType() {
        return this.fTerminateType;
    }

    public void setTerminateType(byte setting) {
        this.fTerminateType = setting;
    }

    public void setBrkptSuspendAllThreads(boolean brkptSuspendAllThreads) {
        this.fBrkptSuspendAllThreads = brkptSuspendAllThreads;
    }

    public boolean isBrkptSuspendAllThreads() {
        if (this.supportsBreakpointSyncAsyncStopControl()) {
            return this.fBrkptSuspendAllThreads;
        }
        return false;
    }

    public void setGlobalEnginePath(String globalEnginePath) {
        this.fGlobalEnginePath = globalEnginePath;
    }

    public String getGlobalEnginePath() {
        return this.fGlobalEnginePath;
    }

    public void setupEPDCDumping(IPDTDebugTarget debugTarget) {
        if (this.loadEPDCFormatters() == 0) {
            return;
        }
        ArrayList<IEPDCFormatter2> validFormatters = new ArrayList<IEPDCFormatter2>();
        IEPDCFormatter2[] iEPDCFormatter2Array = fEPDCFormatters;
        int n = fEPDCFormatters.length;
        int n2 = 0;
        while (n2 < n) {
            IEPDCFormatter2 formatter = iEPDCFormatter2Array[n2];
            if (formatter.isEnabled() && formatter.startSession(debugTarget) != -1) {
                this.fEPDCDumpEnabled = true;
                validFormatters.add(formatter);
            }
            ++n2;
        }
        if (this.fEPDCDumpEnabled) {
            this.fEPDCDumpList = new LinkedList();
            IEPDCFormatter2[] array = validFormatters.toArray(new IEPDCFormatter2[validFormatters.size()]);
            EPDCDumpThread thread = new EPDCDumpThread(array, this.fEPDCDumpList, debugTarget);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadEPDCFormatters() {
        Object object = fFormatterLock;
        synchronized (object) {
            if (fEPDCFormatters == null) {
                fEPDCFormatters = EMPTYFORMATTERS;
                IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.core.epdctraceformatter2");
                if (ep != null) {
                    IConfigurationElement[] configElements;
                    ArrayList<IEPDCFormatter2> tempFormatters = new ArrayList<IEPDCFormatter2>();
                    IConfigurationElement[] iConfigurationElementArray = configElements = ep.getConfigurationElements();
                    int n = configElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement element = iConfigurationElementArray[n2];
                        try {
                            tempFormatters.add((IEPDCFormatter2)element.createExecutableExtension("class"));
                        }
                        catch (CoreException e) {
                            PDTCoreUtils.logError((Exception)((Object)e));
                        }
                        ++n2;
                    }
                    fEPDCFormatters = tempFormatters.toArray(new IEPDCFormatter2[tempFormatters.size()]);
                }
            }
        }
        return fEPDCFormatters.length;
    }

    public void terminateEPDCDumping(IPDTDebugTarget debugTarget) {
        if (this.isEPDCDumpEnabled()) {
            this.addEPDCDump(new byte[0]);
        }
    }

    long getDumpStartTime() {
        return this._DumpStartTime;
    }

    void setDumpStartTime(long dumpStartTime) {
        this._DumpStartTime = dumpStartTime;
    }

    public String getEngineExtensionID() {
        return this._EngineExtensionID;
    }

    public void setEngineExtensionID(String id) {
        this._EngineExtensionID = id;
        try {
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.core.messageformatter");
            if (ep == null) {
                return;
            }
            IConfigurationElement[] configElements = ep.getConfigurationElements();
            int i = 0;
            while (i < configElements.length) {
                Object obj;
                String sid = configElements[i].getAttribute("id");
                if (id.equals(sid) && (obj = configElements[i].createExecutableExtension("class")) instanceof IFormattedString) {
                    this._FormattingClass = (IFormattedString)obj;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IFormattedString getFormattingClass() {
        return this._FormattingClass;
    }

    public boolean isDebugTool() {
        return this._isDebugTool;
    }

    public boolean isSLD() {
        return this._isSLD;
    }

    public boolean iszPICL() {
        return this._iszPICL;
    }

    public boolean is390() {
        return this._is390;
    }

    public boolean is390OS() {
        return this._is390OS;
    }

    public boolean isAIX() {
        return this._isAIX;
    }

    public boolean isDBX() {
        return this._isDBXengine;
    }

    public boolean isTPF41engine() {
        return this._isTPFengine;
    }

    public boolean iszTPFengine() {
        return this._iszTPFengine;
    }

    public boolean isiSeriesEngine() {
        return this._isiSeriesEngine;
    }

    public boolean isiSeriesOS() {
        return this._isiSeriesOS;
    }

    public boolean isPICL() {
        return this._isPICL;
    }

    public boolean hostBIDIStringsAreInVisualFormat() {
        return this.is390() || this.isDebugTool();
    }

    public boolean isIntel() {
        return this._isIntel;
    }

    public int getNegotiatedEPDCVersion() {
        return this._negotiatedEPDCVersion;
    }

    public void setNegotiatedEPDCVersion(int level) {
        this._negotiatedEPDCVersion = level;
    }

    public boolean useStackEntryIndex() {
        return this._useStackEntry;
    }

    public boolean reverseStackEntries() {
        return this._reverseStackEntries;
    }

    public int getConnectionTimeout() {
        return this.fConnectionTimeout * 1000;
    }

    public void setConnectionTimeout(int i) {
        this.fConnectionTimeout = i;
    }

    public ERepGetViews[] getViewInformation() {
        return this.fViewInfos == null ? null : Arrays.copyOf(this.fViewInfos, this.fViewInfos.length);
    }

    public void setViewInformation(ERepGetViews[] viewInfo) {
        this.fViewInfos = viewInfo == null ? null : Arrays.copyOf(viewInfo, viewInfo.length);
    }

    public int getNumViews() {
        return this.fNumberViews;
    }

    public String[] getRepNames() {
        return this._repNames == null ? null : Arrays.copyOf(this._repNames, this._repNames.length);
    }

    protected void initialize() {
        if (this.fViewInfos == null) {
            this.fViewInfos = new ERepGetViews[0];
            this.fNumberViews = 0;
        }
        if (this._repNames == null) {
            this._repNames = new String[0];
        }
        if (this._languageInfo == null) {
            this._languageInfo = new ERepGetLanguages[0];
        }
        if (this._exceptionsInfo == null) {
            this._exceptionsInfo = new ERepGetExceptions[0];
        }
        if (this.getNegotiatedEPDCVersion() > 308) {
            this._isTPFengine = this._engineID == 9;
            this._iszTPFengine = this._engineID == 11;
            this._isDebugTool = this._engineID == 10;
            this._isSLD = this._engineID == 2;
            this._isDBXengine = this._engineID == 3;
            this._isiSeriesEngine = this._engineID == 6;
            this._isiSeriesOS = this._engineOS == 4;
            this._is390 = this._engineHardware == 3 || this._engineHardware == 4;
            this._is390OS = this._engineOS == 2 || this._engineOS == 3 || this._engineOS == 13;
            this._isIntel = this._engineHardware == 1 || this._engineHardware == 2 || this._engineHardware == 10;
            this._isAIX = this._engineOS == 5;
            this._isPICL = this._engineID == 4;
            this._iszPICL = this._isPICL && this._is390;
        } else {
            boolean bl = this._is390 = this._engineOS == 2 || this._engineOS == 3 || this._engineOS == 13;
            if (this._is390 && this._engineID == 4) {
                this._engineID = 10;
            }
            this._isDebugTool = this._engineID == 10;
            this._isSLD = this._engineID == 2;
            this._isDBXengine = this._engineID == 3;
            this._isTPFengine = this._engineID == 9 || this._negotiatedEPDCVersion < 307 && this._isDebugTool;
            this._iszTPFengine = this._engineID == 11;
            this._isIntel = this._engineOS == 6;
            this._isiSeriesOS = this._isiSeriesEngine = this._engineOS == 4;
        }
        if (this._isDebugTool) {
            this._useStackEntry = true;
        }
        if (this._isDebugTool || this._isTPFengine || this._iszTPFengine) {
            this._reverseStackEntries = true;
        }
        char[] mnemonics = new char[]{IEPDCConstants.PLATFORM_OS_CHAR[this.getEngineOS()], IEPDCConstants.ENGINE_TYPE_CHAR[this.getEngineID()], IEPDCConstants.PLATFORM_HDW_CHAR[this.getEngineHardware()]};
        this._engineKey = new String(mnemonics);
    }

    public void setFCTable(EFunctCustTable FCT) {
        this._functCustomTable = FCT;
        this.loadFCTCache();
    }

    public ERepGetLanguages[] getLanguageInfo() {
        return this._languageInfo == null ? null : Arrays.copyOf(this._languageInfo, this._languageInfo.length);
    }

    public ERepGetExceptions[] getExceptionInfo() {
        return this._exceptionsInfo == null ? null : Arrays.copyOf(this._exceptionsInfo, this._exceptionsInfo.length);
    }

    public String[] getMacroGroups() {
        if (this._macroGroups == null) {
            return EMPTYSTRINGS;
        }
        return this._macroGroups.getMacroGroups();
    }

    public int getDefaultSettings() {
        return this._defaultSettings;
    }

    public int getEngineID() {
        return this._engineID;
    }

    public String getEngineIDString() {
        if (this._engineID >= IEPDCConstants.ENGINE_ID_String.length) {
            return "*INVALID_ENGINE_ID*";
        }
        return IEPDCConstants.ENGINE_ID_String[this._engineID];
    }

    public String getEngineLabel() {
        return this._engineLabel;
    }

    public String getEngineVersionString() {
        return this._engineVersionString;
    }

    public String getOSVersionString() {
        return this._OSVersionString;
    }

    public int getEngineOS() {
        return this._engineOS;
    }

    public String getEngineOSString() {
        if (this._engineOS >= IEPDCConstants.PLATFORM_OS_String.length) {
            return "*INVALID_OS*";
        }
        return IEPDCConstants.PLATFORM_OS_String[this._engineOS];
    }

    public int getEngineHardware() {
        return this._engineHardware;
    }

    public String getEngineHardwareString() {
        if (this._engineHardware >= IEPDCConstants.PLATFORM_HDW_String.length) {
            return "*INVALID_HARDWARE*";
        }
        return IEPDCConstants.PLATFORM_HDW_String[this._engineHardware];
    }

    public String getUniqueEngineKey() {
        return this._engineKey;
    }

    public boolean supportsDebugInitialization() {
        return this._fct_supportsDebugInitialization;
    }

    public boolean supportsJobName() {
        return this._fct_supportsJobName;
    }

    public boolean supportsProgramList() {
        return this._fct_supportsProgramList;
    }

    public boolean supportsHostAddress() {
        return this._fct_supportsHostAddress;
    }

    public boolean isLicenseCheckNeeded() {
        return this._fct_forceLicenseCheck;
    }

    public boolean isViewOrderSupported() {
        return this._fct_viewOrder;
    }

    public boolean supportsMultipleThreads() {
        return this._fct_supportsMultipleThreads;
    }

    public boolean supportsTerminateType() {
        return this._fct_supportsTerminateType;
    }

    public boolean supportsForkFollowBoth() {
        return this._fct_supportsForkFollowBoth;
    }

    public boolean supportsChildProcesses() {
        return this._fct_supportsChildProcesses;
    }

    public boolean supportsIncludeFiles() {
        return this._fct_supportsIncludeFiles;
    }

    public boolean supportsDebugOnDemand() {
        return this._fct_supportsDebugOnDemand;
    }

    public boolean supportsStartup() {
        return this._fct_supportsStartup;
    }

    public boolean supportsProcessListStartup() {
        return this._fct_supportsProcessListStartup;
    }

    public boolean supportsPostMortemDebug() {
        return this._fct_supportsPostMortemDebug;
    }

    public boolean supportsPostMortemCapable() {
        return this._fct_supportsPostMortemCapable;
    }

    public boolean supportsEnhancedStorage() {
        return this._fct_supportsEnhancedStorage;
    }

    public boolean supportsAsync() {
        return this._fct_supportsAsync;
    }

    public boolean supportsGetList() {
        return this._fct_supportsGetList;
    }

    public boolean supportsTeamDebug() {
        return this._fct_supportsTeamDebug;
    }

    public boolean supportsMultipleBreakpointRequests() {
        return this._fct_supportsMultipleBreakpointRequests;
    }

    public boolean supportsMultipleRequests() {
        return this._fct_supportsMultipleRequests;
    }

    public boolean supportsEventContent() {
        return this._fct_supportsEventContent;
    }

    public boolean supportsPlayback() {
        return this._fct_supportsplayback;
    }

    public boolean supportsEnhancedCC() {
        return this._fct_supportsEnhancedCC;
    }

    public boolean supportsTrace() {
        return this._fct_supportsTrace;
    }

    public boolean supportsMixedCC() {
        return this._fct_supportsMixedCC;
    }

    public boolean supportsSwitchViewWithMixedCC() {
        return this._fct_supportsMixedCCSwitchView;
    }

    public boolean supportsChangeSourceFile() {
        return this._fct_supportsChangeSourceFile;
    }

    public boolean supportsRestart() {
        return this._fct_supportsRestart;
    }

    public boolean supportsModuleAdd() {
        return this._fct_supportsModuleAdd;
    }

    public boolean supportsModuleRemove() {
        return this._fct_supportsModuleRemove;
    }

    public boolean supportsProcessAttach() {
        return this._fct_supportsProcessAttach;
    }

    public boolean supportsProcessDetach() {
        return this._fct_supportsProcessDetach;
    }

    public boolean supportsProcessDetachKill() {
        return this._fct_supportsProcessDetachKill;
    }

    public boolean supportsProcessDetachKeep() {
        return this._fct_supportsProcessDetachKeep;
    }

    public boolean supportsProcessDetachRelease() {
        return this._fct_supportsProcessDetachRelease;
    }

    public boolean supportsLocalSourceFiles() {
        return this._fct_supportsLocalSourceFiles;
    }

    public boolean supportsSearchLocalFirst() {
        return this._fct_supportsSearchLocalFirst;
    }

    public boolean supportsUpdateEngineSearchPath() {
        return this._fct_supportsUpdateEngineSearchPath;
    }

    public boolean supportsModuleSideFileUpdate() {
        return this._fct_supportsModuleSideFileUpdate;
    }

    public boolean supportsLineBreakpoints() {
        return this._fct_supportsLineBreakpoints;
    }

    public boolean supportsStatementBreakpoints() {
        return this._fct_supportsStatementBreakpoints;
    }

    public boolean supportsFunctionBreakpoints() {
        return this._fct_supportsFunctionBreakpoints;
    }

    public boolean supportsAddressBreakpoints() {
        return this._fct_supportsAddressBreakpoints;
    }

    public boolean supportsChangeAddrBreakpoints() {
        return this._fct_supportsChangeAddrBreakpoints;
    }

    public boolean supportsLoadBreakpoints() {
        return this._fct_supportsLoadBreakpoints;
    }

    public boolean supportsOccurrenceBreakpoints() {
        return this._fct_supportsOccurrenceBreakpoints;
    }

    public boolean supportsEnableDisableBreakpoints() {
        return this._fct_supportsEnableDisableBreakpoints;
    }

    public boolean supportsModifyingBreakpoints() {
        return this._fct_supportsModifyingBreakpoints;
    }

    public boolean supportsDeferredBreakpoints() {
        return this._fct_supportsDeferredBreakpoints;
    }

    public boolean supportsEntryAutoSet() {
        return this._fct_supportsEntryAutoSet;
    }

    public boolean supportsExpressionOnConditionalBkp() {
        return this._fct_supportsExpressionOnConditionalBkp;
    }

    public boolean supportsAddrBkpMonitor_8Bytes() {
        return this._fct_supportsAddrBkpMonitor_8Bytes;
    }

    public boolean supportsAddrBkpMonitor_4Bytes() {
        return this._fct_supportsAddrBkpMonitor_4Bytes;
    }

    public boolean supportsAddrBkpMonitor_2Bytes() {
        return this._fct_supportsAddrBkpMonitor_2Bytes;
    }

    public boolean supportsAddrBkpMonitor_1Bytes() {
        return this._fct_supportsAddrBkpMonitor_1Bytes;
    }

    public boolean supportsAddrBkpMonitor_0_128Bytes() {
        return this._fct_supportsAddrBkpMonitor_0_128Bytes;
    }

    public boolean supportsDateBreakpoints() {
        return this._fct_supportsDateBreakpoints;
    }

    public boolean supportsThreadOnConditionalBkp() {
        return this._fct_supportsThreadOnConditionalBkp;
    }

    public boolean supportsFreqOnConditionalBkp() {
        return this._fct_supportsFreqOnConditionalBkp;
    }

    public boolean supportsAmbiguousBreakpoints() {
        return this._fct_supportsAmbiguousBreakpoints;
    }

    public boolean supportsAmbiguousAllBreakpoints() {
        return this._fct_supportsAmbiguousAllBreakpoints;
    }

    public boolean supportsEngineBreakpoints() {
        return this._fct_supportsEngineBreakpoints;
    }

    public boolean supportsAddrBkpMonitor_Auto() {
        return this._fct_supportsAddrBkpMonitor_Auto;
    }

    public boolean supportsChgAddrContionalBkp() {
        return this._fct_supportsChgAddrContionalBkp;
    }

    public boolean supportsThreadSpecificOnlyBreakpoints() {
        return this._fct_supportsThreadSpecificOnlyBreakpoints;
    }

    public boolean supportsBreakpointActions() {
        return this._fct_supportsBreakpointActions;
    }

    public boolean supportsMacroBreakpoints() {
        return this._fct_supportsMacroBreakpoints;
    }

    public boolean supportsMacroGroupBreakpoints() {
        return this._fct_supportsMacroGroupBreakpoints;
    }

    public boolean supportsEnhancedWatchpointBreakpoints() {
        return this._fct_supportsEnahancedWatchpointBreakpoints;
    }

    public boolean supportsBreakpointSyncAsyncStopControl() {
        return this._fct_supportsBreakpointSyncAsyncStopControl;
    }

    public boolean supportsSourceEntryBreakpoint() {
        return this._fct_supportsSourceEntryBreakpoint;
    }

    public boolean supportsAddressRangeBreakpoints() {
        return this._fct_supportsAddressRangeBreakpoints;
    }

    public boolean supportsZeroAddressBreakpoint() {
        return this._fct_supportsZeroAddressBreakpoints;
    }

    public boolean supportsEnableDisableMonitors() {
        return this._fct_supportsEnableDisableMonitors;
    }

    public boolean supportsMonitorAnyLocals() {
        return this._fct_supportsMonitorAnyLocals;
    }

    public boolean supportsLocalFilters() {
        return this._fct_supportsLocalFilters;
    }

    public boolean supportsMonitorGlobalList() {
        return this._fct_supportsMonitorGlobalList;
    }

    public boolean supportsMonitorGlobalSymbols() {
        return this._fct_supportsMonitorGlobalSymbols;
    }

    public boolean supportsMonitoringExpressions() {
        return this._fct_supportsMonitoringExpressions;
    }

    public boolean supportsNewMonitorFormat() {
        return this._fct_supportsNewMonitorFormat;
    }

    public boolean supportsGetNodeExpression() {
        return this._fct_supportsGetNodeExpression;
    }

    public boolean supportsLocalVariables() {
        return this._fct_supportsLocalVariables;
    }

    public boolean supportsRegisters() {
        return this._fct_supportsRegisters;
    }

    public boolean supportsStack() {
        return this._fct_supportsStack;
    }

    public boolean supportsStorage() {
        return this._fct_supportsStorage;
    }

    public boolean supportsCommandLog() {
        return this._fct_supportsCommandLog;
    }

    public boolean supportsHiddenCommandLog() {
        return this._fct_supportsHiddenCommandLog;
    }

    public boolean supportsProgramIO() {
        return this._fct_supportsProgramIO;
    }

    public boolean supportsModules() {
        return this._fct_supportsModules;
    }

    public boolean supportsThreadFreezeThaw() {
        return this._fct_supportsThreadFreezeThaw;
    }

    public boolean supportsStepOver() {
        return this._fct_supportsStepOver;
    }

    public boolean supportsStepInto() {
        return this._fct_supportsStepInto;
    }

    public boolean supportsStepDebug() {
        return this._fct_supportsStepDebug;
    }

    public boolean supportsStepReturn() {
        return this._fct_supportsStepReturn;
    }

    public boolean supportsRunToLocation() {
        return this._fct_supportsRunToLocation;
    }

    public boolean supportsJumpToLocation() {
        return this._fct_supportsJumpToLocation;
    }

    public boolean supportsHalt() {
        return this._fct_supportsHalt;
    }

    public boolean supportsStorageUsageCheck() {
        return this._fct_supportsStorageUsageCheck;
    }

    public boolean supportsRunToEntry() {
        return this._fct_supportsRunToEntry;
    }

    public boolean supportsSkipNext() {
        return this._fct_supportsSkipNext;
    }

    public boolean supportsExceptionFiltering() {
        return this._fct_supportsExceptionFiltering;
    }

    public boolean supportsExceptionExamine() {
        return this._fct_supportsExceptionExamine;
    }

    public boolean supportsExceptionStep() {
        return this._fct_supportsExceptionStep;
    }

    public boolean supportsExceptionRun() {
        return this._fct_supportsExceptionRun;
    }

    public boolean supportsRememberForkChoice() {
        return this._fct_supportsRememberForkChoice;
    }

    private void loadFCTCache() {
        this._fct_supportsDebugInitialization = this._functCustomTable.isDebugInitializationSupported();
        this._fct_supportsJobName = this._functCustomTable.isJobNameSupported();
        this._fct_supportsProgramList = this._functCustomTable.isProgramFilelistSupported();
        this._fct_supportsHostAddress = this._functCustomTable.isHostAddressSupported();
        this._fct_forceLicenseCheck = this._functCustomTable.isLicenseCheckNeeded();
        this._fct_viewOrder = this._functCustomTable.isViewOrderSupported();
        this._fct_supportsMultipleThreads = this._functCustomTable.isMultipleThreadsSupported();
        this._fct_supportsTerminateType = this._functCustomTable.isTerminatePGMTypeSupported();
        this._fct_supportsForkFollowBoth = this._functCustomTable.isForkFollowBothSupported();
        this._fct_supportsChildProcesses = this._functCustomTable.isChildProcessSupported();
        this._fct_supportsIncludeFiles = this._functCustomTable.isIncludeFilesSupported();
        this._fct_supportsDebugOnDemand = this._functCustomTable.isDebugOnDemandSupported();
        this._fct_supportsStartup = this._functCustomTable.isStartupSupported();
        this._fct_supportsProcessListStartup = this._functCustomTable.isProcessListStartupSupported();
        this._fct_supportsPostMortemDebug = this._functCustomTable.isPostMortemDebugMode();
        this._fct_supportsPostMortemCapable = this._functCustomTable.isPostMortemCapableSupported();
        this._fct_supportsEnhancedStorage = this._functCustomTable.isEnhancedStorageSupported();
        this._fct_supportsAsync = this._functCustomTable.isAsyncSupported();
        this._fct_supportsGetList = this._functCustomTable.isGetListsSupported();
        this._fct_supportsTeamDebug = this._functCustomTable.isTeamDebugSupported();
        this._fct_supportsMultipleBreakpointRequests = this._functCustomTable.isMultipleBreakpointRequestsSupported();
        this._fct_supportsMultipleRequests = this._functCustomTable.isMultipleRequestsSupported();
        this._fct_supportsEventContent = this._functCustomTable.isEventContentSupported();
        this._fct_supportsplayback = this._functCustomTable.isPlaybackSupported();
        this._fct_supportsEnhancedCC = this._functCustomTable.isEnhancedCCSupported();
        this._fct_supportsMixedCC = this._functCustomTable.isCCMixedSupported();
        this._fct_supportsMixedCCSwitchView = this._functCustomTable.isCCSwitchViewWhenMixedSupported();
        this._fct_supportsTrace = this._functCustomTable.isTraceSupported();
        this._fct_supportsChangeSourceFile = this._functCustomTable.isChangeSourceFileSupported();
        this._fct_supportsRestart = this._functCustomTable.isRestartSupported();
        this._fct_supportsModuleAdd = this._functCustomTable.isModuleAddSupported();
        this._fct_supportsModuleRemove = this._functCustomTable.isModuleRemoveSupported();
        this._fct_supportsProcessAttach = this._functCustomTable.isProcessAttachSupported();
        this._fct_supportsProcessDetach = this._functCustomTable.isProcessDetachSupported();
        this._fct_supportsProcessDetachKill = this._functCustomTable.isProcessDetachKillSupported();
        this._fct_supportsProcessDetachKeep = this._functCustomTable.isProcessDetachKeepSupported();
        this._fct_supportsProcessDetachRelease = this._functCustomTable.isProcessDetachReleaseSupported();
        this._fct_supportsLocalSourceFiles = this._functCustomTable.isLocalSourceFilesSupported();
        this._fct_supportsSearchLocalFirst = this._functCustomTable.isSearchLocalFirst();
        this._fct_supportsUpdateEngineSearchPath = this._functCustomTable.isEngineSearchPathUpdateSupported();
        this._fct_supportsModuleSideFileUpdate = this._functCustomTable.isModuleSideFileUpdateSupported();
        this._fct_supportsLineBreakpoints = this._functCustomTable.isLineBreakpointsSupported();
        this._fct_supportsStatementBreakpoints = this._functCustomTable.isStatementBreakpointSupported();
        this._fct_supportsFunctionBreakpoints = this._functCustomTable.isFunctionBreakpointsSupported();
        this._fct_supportsAddressBreakpoints = this._functCustomTable.isAddressBreakpointsSupported();
        this._fct_supportsChangeAddrBreakpoints = this._functCustomTable.isWatchpointsSupported();
        this._fct_supportsLoadBreakpoints = this._functCustomTable.isModuleLoadBreakpointsSupported();
        this._fct_supportsOccurrenceBreakpoints = this._functCustomTable.isOccurrenceBreakpointsSupported();
        this._fct_supportsEnableDisableBreakpoints = this._functCustomTable.isBreakpointEnableDisableSupported();
        this._fct_supportsModifyingBreakpoints = this._functCustomTable.isBreakpointModifySupported();
        this._fct_supportsDeferredBreakpoints = this._functCustomTable.isDeferredBreakpointsSupported();
        this._fct_supportsEntryAutoSet = this._functCustomTable.isEntryBreakpointsAutoSetSupported();
        this._fct_supportsExpressionOnConditionalBkp = this._functCustomTable.isConditionalBreakpointsSupported();
        this._fct_supportsAddrBkpMonitor_8Bytes = this._functCustomTable.isMonitor8BytesSupported();
        this._fct_supportsAddrBkpMonitor_4Bytes = this._functCustomTable.isMonitor4BytesSupported();
        this._fct_supportsAddrBkpMonitor_2Bytes = this._functCustomTable.isMonitor2BytesSupported();
        this._fct_supportsAddrBkpMonitor_1Bytes = this._functCustomTable.isMonitor1BytesSupported();
        this._fct_supportsAddrBkpMonitor_0_128Bytes = this._functCustomTable.isMonitor0_128BytesSupported();
        this._fct_supportsDateBreakpoints = this._functCustomTable.isDateBreakpointsSupported();
        this._fct_supportsThreadOnConditionalBkp = this._functCustomTable.isBreakpointThreadsSupported();
        this._fct_supportsFreqOnConditionalBkp = this._functCustomTable.isBreakpointFrequencySupported();
        this._fct_supportsAmbiguousBreakpoints = this._functCustomTable.isAmbiguousBreakpointSupported();
        this._fct_supportsAmbiguousAllBreakpoints = this._functCustomTable.isAmbiguousAllBreakpointSupported();
        this._fct_supportsEngineBreakpoints = this._functCustomTable.isEngineBreakpointSupported();
        this._fct_supportsAddrBkpMonitor_Auto = this._functCustomTable.isMonitorAutoSupported();
        this._fct_supportsChgAddrContionalBkp = this._functCustomTable.isChgaddrConditionalBreakpointsSupported();
        this._fct_supportsThreadSpecificOnlyBreakpoints = this._functCustomTable.isThreadSpecificBreakpointsOnlySupported();
        this._fct_supportsBreakpointActions = this._functCustomTable.isBreakpointActionsSupported();
        this._fct_supportsMacroBreakpoints = this._functCustomTable.isMacroBreakpointsSupported();
        this._fct_supportsMacroGroupBreakpoints = this._functCustomTable.isMacroGroupBreakpointsSupported();
        this._fct_supportsEnahancedWatchpointBreakpoints = this._functCustomTable.isEnhancedWatchpointsSupported();
        this._fct_supportsBreakpointSyncAsyncStopControl = this._functCustomTable.isBreakpointSyncAsyncStopControlSupported();
        this._fct_supportsSourceEntryBreakpoint = this._functCustomTable.isSourceEntryBreakpointSupported();
        this._fct_supportsAddressRangeBreakpoints = this._functCustomTable.isAddressRangeBreakpointsSupported();
        this._fct_supportsZeroAddressBreakpoints = this._functCustomTable.isZeroAddressBreakpointsSupported();
        this._fct_supportsEnableDisableMonitors = this._functCustomTable.isMonitorEnableDisableSupported();
        this._fct_supportsMonitorAnyLocals = this._functCustomTable.isMonitorAnyLocalsSupported();
        this._fct_supportsLocalFilters = this._functCustomTable.isLocalFiltersSupported();
        this._fct_supportsMonitorGlobalList = this._functCustomTable.isGlobalListSupported();
        this._fct_supportsMonitorGlobalSymbols = this._functCustomTable.isGlobalSymbolsSupported();
        this._fct_supportsMonitoringExpressions = this._functCustomTable.isMonitoringExpressionsSupported();
        this._fct_supportsNewMonitorFormat = this._functCustomTable.isNewMonitorFormatSupported();
        this._fct_supportsGetNodeExpression = this._functCustomTable.isGetNodeExpressionSupported();
        this._fct_supportsLocalVariables = this._functCustomTable.isMonitorLocalVariablesSupported();
        this._fct_supportsRegisters = this._functCustomTable.isMonitorRegistersSupported();
        this._fct_supportsStack = this._functCustomTable.isMonitorStackSupported();
        this._fct_supportsStorage = this._functCustomTable.isMonitorStorageSupported();
        this._fct_supportsCommandLog = this._functCustomTable.isCommandLogSupported();
        this._fct_supportsHiddenCommandLog = this._functCustomTable.isHiddenCommandLogSupported();
        this._fct_supportsProgramIO = this._functCustomTable.isProgramIOSupported();
        this._fct_supportsModules = this._functCustomTable.isModulesViewSupported();
        this._fct_supportsThreadFreezeThaw = this._functCustomTable.isThreadFreezeThawSupported();
        this._fct_supportsStepOver = this._functCustomTable.isStepOverSupported();
        this._fct_supportsStepInto = this._functCustomTable.isStepIntoSupported();
        this._fct_supportsStepDebug = this._functCustomTable.isStepDebugSupported();
        this._fct_supportsStepReturn = this._functCustomTable.isStepReturnSupported();
        this._fct_supportsRunToLocation = this._functCustomTable.isRunToLocationSupported();
        this._fct_supportsJumpToLocation = this._functCustomTable.isJumpToLocationSupported();
        this._fct_supportsHalt = this._functCustomTable.isHaltSupported();
        this._fct_supportsStorageUsageCheck = this._functCustomTable.isStorageUsageCheckSupported();
        this._fct_supportsRunToEntry = this._functCustomTable.isRunToEntrySupported();
        this._fct_supportsSkipNext = this._functCustomTable.isSkipNextSupported();
        this._fct_supportsExceptionFiltering = this._functCustomTable.isExceptionFilterSupported();
        this._fct_supportsExceptionExamine = this._functCustomTable.isExceptionExamineSupported();
        this._fct_supportsExceptionStep = this._functCustomTable.isExceptionStepSupported();
        this._fct_supportsExceptionRun = this._functCustomTable.isExceptionRunSupported();
        this._fct_supportsRememberForkChoice = this.isTPF41engine() || this.iszTPFengine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEPDCDump(byte[] buffer) {
        LinkedList<byte[]> linkedList = this.fEPDCDumpList;
        synchronized (linkedList) {
            this.fEPDCDumpList.add(buffer);
            this.fEPDCDumpList.notify();
        }
    }

    public boolean isAuthenticateConnection() {
        return this.fAuthenticateConnection;
    }

    public void setAuthenticateConnection(boolean authenticateConnection) {
        this.fAuthenticateConnection = authenticateConnection;
    }

    public String getUserId() {
        return this.fUserId;
    }

    public void setUserId(String userId) {
        this.fUserId = userId;
    }

    public char[] getPassword() {
        return this.fPassword;
    }

    public void setPassword(char[] password) {
        this.fPassword = password;
    }

    public ERepGetPlaybackOptions[] getPlaybackOptions() {
        return this.fPlaybackOptions == null ? null : Arrays.copyOf(this.fPlaybackOptions, this.fPlaybackOptions.length);
    }

    public void updatePlaybackOptions(List<ERepGetPlaybackOptions> options) {
        if (this.fPlaybackOptions != null) {
            int i = 0;
            while (i < this.fPlaybackOptions.length) {
                ERepGetPlaybackOptions o = this.fPlaybackOptions[i];
                int index = options.indexOf(o);
                if (index > -1) {
                    ERepGetPlaybackOptions o2 = options.get(index);
                    o.setBooleanValue(o2.getBooleanValue());
                    o.setStringValue(o.getStringValue());
                }
                ++i;
            }
        }
    }

    public final BreakpointFactory getBreakpointFactory() {
        return this.fBreakpointFactory;
    }

    public final void setBreakpointFactory(BreakpointFactory breakpointFactory) {
        this.fBreakpointFactory = breakpointFactory;
    }

    public boolean setRequestedViewOrder(int[] requestedViewOrder) {
        if (requestedViewOrder == null || requestedViewOrder.length != this.fViewInfos.length - 1) {
            return false;
        }
        this.fRequestedViewOrder = Arrays.copyOf(requestedViewOrder, requestedViewOrder.length);
        return true;
    }

    public int[] getRequestedViewOrder() {
        return this.fRequestedViewOrder == null ? null : Arrays.copyOf(this.fRequestedViewOrder, this.fRequestedViewOrder.length);
    }

    public String[] getEPDCDumpFileLocation(IPDTDebugTarget debugTarget) {
        ArrayList<String> epdcDumpLocations = new ArrayList<String>();
        if (fEPDCFormatters != null && fEPDCFormatters != EMPTYFORMATTERS) {
            IEPDCFormatter2[] iEPDCFormatter2Array = fEPDCFormatters;
            int n = fEPDCFormatters.length;
            int n2 = 0;
            while (n2 < n) {
                String dumpFileLocation;
                IEPDCFormatter2 formatter = iEPDCFormatter2Array[n2];
                if (formatter instanceof IEPDCFormatter3 && (dumpFileLocation = ((IEPDCFormatter3)((Object)formatter)).getEPDCDumpLocation(debugTarget)) != null) {
                    epdcDumpLocations.add(dumpFileLocation);
                }
                ++n2;
            }
        }
        String[] resultArray = new String[epdcDumpLocations.size()];
        return epdcDumpLocations.toArray(resultArray);
    }
}

