/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_Base;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;

public class EPDC_DumpUtils {
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_COLOUR = "colour";
    public static final String ELEMENT_STRUCTURE = "STRUCTURE";
    public static final String ELEMENT_HEADER = "HEADER";
    public static final String ELEMENT_VARIABLE = "VARIABLE";
    public static final String ELEMENT_PACKET = "PACKET";

    private static String escapeXML(String orig) {
        if (orig == null) {
            return "NULL";
        }
        String replace = orig.replaceAll("<", "&lt;");
        replace = replace.replaceAll(">", "&gt;");
        replace = replace.replaceAll("&", "&amp;");
        replace = replace.replaceAll("\"", "&quot;");
        replace = replace.replaceAll("'", "&apos;");
        replace = replace.replaceAll("[\u0000-\u001f]", ".");
        return replace;
    }

    public static String unescapeXML(String orig) {
        if (orig == null) {
            return "NULL";
        }
        String replace = orig.replaceAll("&lt;", "<");
        replace = replace.replaceAll("&gt;", ">");
        replace = replace.replaceAll("&amp;", "&");
        replace = replace.replaceAll("&quot;", "\"");
        replace = replace.replaceAll("&apos;", "'");
        return replace;
    }

    public static String makePrintable(String input) {
        if (input == null) {
            return "NULL";
        }
        StringBuilder buffer = new StringBuilder(input.length());
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (Character.isISOControl(c)) {
                buffer.append('?');
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void beginStructure(DataOutputStream dataOutputStream, String description) throws IOException {
        String tmp = String.format("<STRUCTURE name=\"%s\">", EPDC_DumpUtils.escapeXML(description));
        dataOutputStream.write(tmp.getBytes("UTF-8"));
    }

    public static void endStructure(DataOutputStream dataOutputStream) throws IOException {
        String tmp = "</STRUCTURE>";
        dataOutputStream.write(tmp.getBytes("UTF-8"));
    }

    public static void startHeader(DataOutputStream dataOutputStream) throws IOException {
        String tmp = "<HEADER>";
        dataOutputStream.write(tmp.getBytes("UTF-8"));
    }

    public static void endHeader(DataOutputStream dataOutputStream) throws IOException {
        String tmp = "</HEADER>";
        dataOutputStream.write(tmp.getBytes("UTF-8"));
    }

    public static void beginPacket(DataOutputStream dataOutputStream, EPDC_Base packet) throws IOException {
        String tmp = "<PACKET type=\"" + packet.getPacketType() + "\" description=\"" + packet.getDescription() + "\">";
        dataOutputStream.write(tmp.getBytes("UTF-8"));
    }

    public static void endPacket(DataOutputStream dataOutputStream) throws IOException {
        String tmp = "</PACKET>";
        dataOutputStream.write(tmp.getBytes("UTF-8"));
    }

    public static void writeVariable(DataOutputStream dataOutputStream, String name, String value) throws IOException {
        String tmp = "<VARIABLE name=\"" + EPDC_DumpUtils.escapeXML(name) + "\"><![CDATA[" + EPDC_DumpUtils.makePrintable(value) + "]]></VARIABLE>";
        dataOutputStream.write(tmp.getBytes("UTF-8"));
    }

    public static void writeVariable(DataOutputStream dataOutputStream, String name, EStdString value) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, name, value == null ? "NULL" : value.toString());
    }

    public static void writeVariable(DataOutputStream dataOutputStream, String name, int value) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, name, String.valueOf(value));
    }

    public static void writeVariable(DataOutputStream dataOutputStream, String name, boolean value) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, name, String.valueOf(value));
    }

    public static void writeFlagDetails(DataOutputStream dataOutputStream, String name, int val, NameVal[] constants) throws IOException {
        EPDC_DumpUtils.beginStructure(dataOutputStream, String.format("%s = 0x%08X", name, val));
        EPDC_DumpUtils.writeFlagDetailsCommon(dataOutputStream, val, 8, constants);
        EPDC_DumpUtils.endStructure(dataOutputStream);
    }

    public static void writeFlagDetails(DataOutputStream dataOutputStream, String name, byte val, NameVal[] constants) throws IOException {
        EPDC_DumpUtils.beginStructure(dataOutputStream, String.format("%s = 0x%02X", name, val));
        EPDC_DumpUtils.writeFlagDetailsCommon(dataOutputStream, val, 2, constants);
        EPDC_DumpUtils.endStructure(dataOutputStream);
    }

    public static void writeFlagDetails(DataOutputStream dataOutputStream, String name, short val, NameVal[] constants) throws IOException {
        EPDC_DumpUtils.beginStructure(dataOutputStream, String.format("%s = 0x%04X", name, val));
        EPDC_DumpUtils.writeFlagDetailsCommon(dataOutputStream, val, 4, constants);
        EPDC_DumpUtils.endStructure(dataOutputStream);
    }

    public static void writeFlagDetailsCommon(DataOutputStream dataOutputStream, int val, int flagLen, NameVal[] constants) throws IOException {
        int n = 0;
        while (n < constants.length) {
            boolean enabled = (val & constants[n].fVal) != 0;
            String name = String.format("0x%0" + flagLen + "X %s %s", constants[n].fVal, enabled ? "*" : " ", constants[n].fName);
            dataOutputStream.write(String.format("<VARIABLE><![CDATA[%s]]></VARIABLE>", name).getBytes("UTF-8"));
            ++n;
        }
    }

    public static String getAttrbuteName(Class<?> classToSearch, String regex, int val) {
        Field[] f = classToSearch.getFields();
        try {
            int n = 0;
            while (n < f.length) {
                if (f[n].getName().matches(regex) && f[n].getInt(f[n]) == val) {
                    return f[n].getName() + "  (" + val + ")";
                }
                ++n;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return Integer.toString(val);
    }

    public static String getAttrbuteName(NameVal[] constants, int val) {
        int n = 0;
        while (n < constants.length) {
            if (constants[n].fVal == val) {
                return constants[n].fName + "  (" + val + ")";
            }
            ++n;
        }
        return Integer.toString(val);
    }

    public static void writeBytes(DataOutputStream dos, String name, byte[] bytes, int startOffset) throws IOException {
        EPDC_DumpUtils.beginStructure(dos, name);
        int rows = bytes.length / 16;
        rows += bytes.length % 16 > 0 ? 1 : 0;
        StringBuilder line = new StringBuilder();
        StringBuilder text = new StringBuilder(16);
        byte[] singleByte = new byte[1];
        int offset = 0;
        int r = 0;
        while (r < rows) {
            text.setLength(0);
            line.setLength(0);
            line.append("<VARIABLE name=\"");
            line.append(String.format("0x%03X", offset + startOffset));
            line.append("\"><![CDATA[");
            int j = 0;
            while (j < 16) {
                if (j != 0 && j % 4 == 0) {
                    text.append(" ");
                    line.append(" ");
                }
                if (offset < bytes.length) {
                    byte b = bytes[offset];
                    if (b < 0 || Character.isISOControl(b)) {
                        text.append(".");
                    } else {
                        singleByte[0] = b;
                        text.append(new String(singleByte, "UTF-8"));
                    }
                    line.append(String.format("%02X ", bytes[offset++]));
                } else {
                    text.append(".");
                    line.append(" __");
                }
                ++j;
            }
            line.append("  ").append((CharSequence)text);
            line.append("]]></VARIABLE>");
            dos.write(line.toString().getBytes("UTF-8"));
            ++r;
        }
        EPDC_DumpUtils.endStructure(dos);
    }

    public static class NameVal {
        int fVal;
        String fName;

        NameVal(int val, String name) {
            this.fVal = val;
            if (this.fVal < 0) {
                this.fVal = Math.abs(this.fVal);
            }
            this.fName = name;
        }
    }
}

