/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.BkptChangePacket;
import com.ibm.debug.pdt.internal.epdc.CCChangePacket;
import com.ibm.debug.pdt.internal.epdc.EPDC_Base;
import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.FCTChangePacket;
import com.ibm.debug.pdt.internal.epdc.InvalidChangePacket;
import com.ibm.debug.pdt.internal.epdc.LogChangePacket;
import com.ibm.debug.pdt.internal.epdc.ModuleChangePacket;
import com.ibm.debug.pdt.internal.epdc.MonitorChangePacket;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import com.ibm.debug.pdt.internal.epdc.PartChangePacket;
import com.ibm.debug.pdt.internal.epdc.RegisterChangePacket;
import com.ibm.debug.pdt.internal.epdc.StackChangePacket;
import com.ibm.debug.pdt.internal.epdc.StorageChangePacket;
import com.ibm.debug.pdt.internal.epdc.ThreadChangePacket;
import com.ibm.debug.pdt.internal.epdc.TraceChangePacket;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public abstract class EPDC_ChangePacket
extends EPDC_Base {
    private int _change_type;
    private int _total_bytes;
    private int _total_changed_items = 0;
    private int _num_chgd_in_packet = 0;
    private EPDC_Reply _reply;
    ArrayList<EPDC_ChangeItem> fChangeItems = new ArrayList();

    EPDC_ChangePacket(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession, EPDC_Reply reply) throws IOException {
        super(byteBuffer, engineSession);
        this._reply = reply;
        dataInputStream.skipBytes(4);
        this._change_type = dataInputStream.readInt();
        this._total_bytes = dataInputStream.readInt();
        this._total_changed_items = dataInputStream.readInt();
        this._num_chgd_in_packet = dataInputStream.readInt();
        if (this.getNumChgItems() == 1) {
            EPDC_ChangeItem chgItem = this.createChangeItem(byteBuffer, dataInputStream, engineSession);
            this.fChangeItems.add(chgItem);
            reply.add(chgItem);
        } else {
            int i = 0;
            while (i < this.getNumChgItems()) {
                EPDC_ChangeItem chgItem = this.createChangeItem(byteBuffer, new OffsetDataInputStream(byteBuffer, dataInputStream.readInt()), engineSession);
                this.fChangeItems.add(chgItem);
                reply.add(chgItem);
                ++i;
            }
        }
    }

    int getNumChgItems() {
        return this._num_chgd_in_packet;
    }

    int getTotalChgItems() {
        return this._total_changed_items;
    }

    public static EPDC_ChangePacket decodeChangePacketStream(InputStream inputStream, int totalBytes, EPDC_Reply reply, EPDC_EngineSession engineSession) throws IOException {
        byte[] bytes = EPDC_ChangePacket.getPacket(inputStream, totalBytes);
        if (engineSession.isEPDCDumpEnabled()) {
            EPDC_Base.dumpEPDC(bytes, engineSession, (byte)2);
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(bytes));
        dataInputStream.mark(8);
        dataInputStream.skipBytes(4);
        int chgPktType = dataInputStream.readInt();
        dataInputStream.reset();
        switch (chgPktType) {
            case 17: {
                return new FCTChangePacket(bytes, dataInputStream, engineSession, reply);
            }
            case 12: {
                return new ModuleChangePacket(bytes, dataInputStream, engineSession, reply);
            }
            case 3: {
                return new ThreadChangePacket(bytes, dataInputStream, engineSession, reply);
            }
            case 1: {
                return new PartChangePacket(bytes, dataInputStream, engineSession, reply);
            }
            case 2: {
                return new BkptChangePacket(bytes, dataInputStream, engineSession, reply);
            }
            case 4: {
                return new MonitorChangePacket(bytes, dataInputStream, engineSession, reply);
            }
            case 10: {
                return new StackChangePacket(bytes, dataInputStream, engineSession, reply);
            }
            case 14: {
                return new RegisterChangePacket(bytes, dataInputStream, engineSession, reply);
            }
            case 9: {
                return new StorageChangePacket(bytes, dataInputStream, engineSession, reply);
            }
            case 13: {
                return new LogChangePacket(bytes, dataInputStream, engineSession, reply);
            }
            case 18: {
                return new CCChangePacket(bytes, dataInputStream, engineSession, reply);
            }
            case 19: {
                return new TraceChangePacket(bytes, dataInputStream, engineSession, reply);
            }
        }
        PDTCoreUtils.logString(reply, " Unknown epdc change packet typeCode:" + chgPktType);
        return new InvalidChangePacket(bytes, dataInputStream, engineSession, reply);
    }

    int getChangeCode() {
        return this._change_type;
    }

    public EPDC_Reply getReply() {
        return this._reply;
    }

    @Override
    final void output(DataOutputStream dataOutputStream) throws IOException {
    }

    @Override
    final int getFixedLen() {
        return 0;
    }

    @Override
    final int getVarLen() {
        return 0;
    }

    @Override
    public String getPacketType() {
        return "Change packet";
    }

    abstract EPDC_ChangeItem createChangeItem(byte[] var1, DataInputStream var2, EPDC_EngineSession var3) throws IOException;

    @Override
    public final void writeFormattedEPDC(DataOutputStream dataOutputStream, boolean dumpHex) throws IOException {
        EPDC_DumpUtils.NameVal[] changeConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(0, "UNDEFINED_CHANGE"), new EPDC_DumpUtils.NameVal(1, "PART_CHANGE"), new EPDC_DumpUtils.NameVal(2, "BREAKPOINT_CHANGE"), new EPDC_DumpUtils.NameVal(3, "THREAD_CHANGE"), new EPDC_DumpUtils.NameVal(4, "MONITOR_CHANGE"), new EPDC_DumpUtils.NameVal(9, "STORAGE_CHANGE"), new EPDC_DumpUtils.NameVal(10, "STACK_CHANGE"), new EPDC_DumpUtils.NameVal(12, "MODULE_CHANGE"), new EPDC_DumpUtils.NameVal(13, "LOG_CHANGE"), new EPDC_DumpUtils.NameVal(14, "REGISTER_CHANGE"), new EPDC_DumpUtils.NameVal(17, "FCT_CHANGE"), new EPDC_DumpUtils.NameVal(18, "CC_CHANGE"), new EPDC_DumpUtils.NameVal(19, "TRACE_CHANGE")};
        EPDC_DumpUtils.beginPacket(dataOutputStream, this);
        EPDC_DumpUtils.startHeader(dataOutputStream);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "change_name", this.getDescription());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "change_type", EPDC_DumpUtils.getAttrbuteName(changeConstants, this._change_type));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "length", this._total_bytes);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Total changed items with this reply", this._total_changed_items);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Number changed items in this packet", this._num_chgd_in_packet);
        EPDC_DumpUtils.endHeader(dataOutputStream);
        this.writeEPDC(dataOutputStream);
        if (dumpHex) {
            EPDC_DumpUtils.writeBytes(dataOutputStream, String.format("Hex dump: Length = %1$d,0x%1$02X", this.getByteBuffer().length), this.getByteBuffer(), 0);
        }
        EPDC_DumpUtils.endPacket(dataOutputStream);
    }
}

