/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class EPDC_Base {
    static final String[] EMPTYSTRINGS = new String[0];
    static final EStdString[] EMPTYESTDSTRINGS = new EStdString[0];
    static final int[] EMPTYINTARRAY = new int[0];
    static final short[] EMPTYSHORTARRAY = new short[0];
    static final int MAXUNSIGNEDSHORT = 65535;
    static final String NULLSTRING = "!NULL!";
    private int _totalBytes = 0;
    private transient byte[] _byteBuffer;
    private transient EPDC_EngineSession _engineSession;

    EPDC_Base() {
    }

    EPDC_Base(byte[] byteBuffer, EPDC_EngineSession engineSession) {
        this(engineSession);
        this._byteBuffer = byteBuffer;
    }

    EPDC_Base(EPDC_EngineSession engineSession) {
        if (engineSession != null) {
            this._engineSession = engineSession;
        }
    }

    abstract void output(DataOutputStream var1) throws IOException;

    abstract int getFixedLen();

    abstract int getVarLen();

    static final int writeOffsetOrZero(DataOutputStream os, int offset, EPDC_Base object) throws IOException {
        if (object == null) {
            os.writeInt(0);
            return 0;
        }
        int total = object.getTotalBytes();
        if (total == 0) {
            os.writeInt(0);
        } else {
            os.writeInt(offset);
        }
        return total;
    }

    int getTotalBytes() {
        if (this._totalBytes == 0) {
            this._totalBytes = this.getFixedLen() + this.getVarLen();
        }
        return this._totalBytes;
    }

    void setTotalBytes(int totalBytes) {
        this._totalBytes = totalBytes;
    }

    static int getTotalBytes(EPDC_Base object) {
        return object == null ? 0 : object.getTotalBytes();
    }

    static final short getPlatformIdentifier() {
        String osName = System.getProperty("os.name");
        if (osName != null) {
            if (osName.startsWith("Win")) {
                return 6;
            }
            if (osName.startsWith("AIX")) {
                return 5;
            }
            if (osName.startsWith("Linux")) {
                return 10;
            }
            if (osName.toLowerCase().startsWith("mac")) {
                return 14;
            }
        }
        return 0;
    }

    final int getEPDCVersion() {
        return this._engineSession.getNegotiatedEPDCVersion();
    }

    final EPDC_EngineSession getEPDCEngineSession() {
        return this._engineSession;
    }

    final byte[] getByteBuffer() {
        return this._byteBuffer;
    }

    static void dumpEPDC(byte[] bytes, EPDC_EngineSession engineSession, byte packetType) throws IOException {
        if (packetType == 3 || bytes.length == 0) {
            return;
        }
        long timeStamp = System.currentTimeMillis();
        long lastTimeStamp = engineSession.getDumpStartTime();
        if (lastTimeStamp == 0L) {
            engineSession.setDumpStartTime(timeStamp);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeLong(timeStamp);
            dos.write(new byte[56]);
            EPDC_Base.writeDumpPacket(baos.toByteArray(), (byte)4, engineSession, 0);
        }
        EPDC_Base.writeDumpPacket(bytes, packetType, engineSession, lastTimeStamp == 0L ? 0 : (int)(timeStamp - lastTimeStamp));
    }

    private static void writeDumpPacket(byte[] bytes, byte packetType, EPDC_EngineSession engineSession, int timeStamp) throws IOException {
        boolean timerFlag = true;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length + 12);
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(0);
        dos.writeByte(0);
        dos.writeByte(1);
        dos.writeByte(packetType);
        dos.writeInt(bytes.length);
        dos.writeInt(timeStamp);
        dos.write(bytes);
        engineSession.addEPDCDump(baos.toByteArray());
    }

    public static final String getClassName(Object o) {
        if (o == null) {
            return "<NULL>";
        }
        String name = o.getClass().getName();
        int indexOfLastDot = name.lastIndexOf(46);
        if (indexOfLastDot != -1) {
            name = name.substring(indexOfLastDot + 1);
        }
        return name;
    }

    static byte[] getPacket(InputStream inputStream, int totalBytes) throws IOException {
        int totBytes;
        DataInputStream inStream = new DataInputStream(inputStream);
        int n = totBytes = totalBytes == 0 ? inStream.readInt() : totalBytes;
        if (totalBytes < 0) {
            PDTCoreUtils.logString(EPDC_Base.class.getName(), "Packet total bytes should not be negative:" + totalBytes, 2);
            throw new EOFException();
        }
        byte[] bytes = null;
        try {
            bytes = new byte[totBytes];
        }
        catch (OutOfMemoryError e) {
            PDTCoreUtils.logString(EPDC_Base.class.getName(), "Packet size is too large:" + totBytes, 2);
            throw new EOFException();
        }
        inStream.readFully(bytes);
        return bytes;
    }

    public abstract void writeFormattedEPDC(DataOutputStream var1, boolean var2) throws IOException;

    public abstract void writeEPDC(DataOutputStream var1) throws IOException;

    public abstract String getDescription();

    public abstract String getPacketType();

    public String toString() {
        return this.getDescription();
    }
}

