/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import java.util.regex.Pattern;

public class EPDCUtils {
    private static final String MESSAGE_ID_REGEX = "^[A-Z]{3,6}\\d{2,5}[EIWS]?:?\\s.*";
    private static final Pattern msgPattern = Pattern.compile("^[A-Z]{3,6}\\d{2,5}[EIWS]?:?\\s.*");
    private static final String MESSAGE_ID_REGEX_ISERIES = "^.*:\\s[A-Z]{3}\\p{XDigit}{4}\\s.*";
    private static final Pattern msgPatterniSeries = Pattern.compile("^.*:\\s[A-Z]{3}\\p{XDigit}{4}\\s.*");

    private EPDCUtils() {
    }

    public static boolean isValidMessageID(String msg) {
        boolean found = msgPattern.matcher(msg).find();
        if (!found) {
            found = EPDCUtils.isSpecialiSeriesFormat(msg);
        }
        return found;
    }

    private static boolean isSpecialiSeriesFormat(String msg) {
        return msgPatterniSeries.matcher(msg).find();
    }

    public static String getValidMessageID(String msg) {
        if (EPDCUtils.isValidMessageID(msg)) {
            if (EPDCUtils.isSpecialiSeriesFormat(msg)) {
                int start = msg.indexOf(": ") + 2;
                int end = msg.indexOf(32, start);
                if (start == -1 || end == -1) {
                    return "";
                }
                return msg.trim().substring(start, end);
            }
            String messageID = msg.trim().substring(0, msg.indexOf(32));
            if (messageID.endsWith(":")) {
                return messageID.substring(0, messageID.indexOf(58));
            }
            return messageID;
        }
        return "";
    }
}

