/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.core.IEPDCFormatter2;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class EPDCDumpThread
extends Thread {
    private IPDTDebugTarget fDebugTarget;
    private IEPDCFormatter2[] fFormatters;
    private LinkedList<byte[]> fEPDCDumpList;

    public EPDCDumpThread(IEPDCFormatter2[] formatters, LinkedList<byte[]> EPDCdumpList, IPDTDebugTarget debugTarget) {
        super("EPDC Dump thread");
        this.setDaemon(true);
        this.fFormatters = formatters;
        this.fEPDCDumpList = EPDCdumpList;
        this.fDebugTarget = debugTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OutputStream[] outputStreams = new OutputStream[this.fFormatters.length];
        int i = 0;
        while (i < this.fFormatters.length) {
            outputStreams[i] = this.fFormatters[i].getOutputStream(this.fDebugTarget);
            ++i;
        }
        while (true) {
            byte[] bytes = null;
            LinkedList<byte[]> linkedList = this.fEPDCDumpList;
            synchronized (linkedList) {
                if (this.fEPDCDumpList.isEmpty()) {
                    try {
                        this.fEPDCDumpList.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    bytes = this.fEPDCDumpList.removeFirst();
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            if (bytes == null || bytes.length == 0) break;
            int i2 = 0;
            while (i2 < outputStreams.length) {
                if (outputStreams[i2] != null) {
                    try {
                        outputStreams[i2].write(bytes);
                        outputStreams[i2].flush();
                    }
                    catch (IOException e) {
                        PDTCoreUtils.logString(this, "EPDC Formatter has failed (" + e.getMessage() + ")", 2);
                        OutputStream errorStream = outputStreams[i2];
                        outputStreams[i2] = null;
                        try {
                            errorStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                ++i2;
            }
            bytes = null;
        }
        i = 0;
        while (i < this.fFormatters.length) {
            try {
                if (outputStreams[i] != null) {
                    outputStreams[i].flush();
                    outputStreams[i].close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fFormatters[i].endSession(this.fDebugTarget);
            ++i;
        }
    }
}

