/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EFunctCustTable
extends EPDC_Structures
implements IEPDCConstants {
    private int _startup;
    private int _general_functions;
    private int _file_options;
    private int _storage_options;
    private int _breakpoint_options;
    private int _breakpoint_options_2;
    private int _monitor_options;
    private int _windows_options;
    private int _run_options;
    private int _exception_options;
    private int _stack_options;
    private static final int FIXED_LENGTH = 40;

    EFunctCustTable(DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(engineSession);
        this._startup = dataInputStream.readInt();
        this._general_functions = dataInputStream.readInt();
        this._file_options = dataInputStream.readInt();
        this._storage_options = dataInputStream.readInt();
        this._breakpoint_options = dataInputStream.readInt();
        this._monitor_options = dataInputStream.readInt();
        this._windows_options = dataInputStream.readInt();
        this._run_options = dataInputStream.readInt();
        this._exception_options = dataInputStream.readInt();
        this._stack_options = dataInputStream.readInt();
        if (this.isExtendedBreakpointFCTSupported()) {
            this._breakpoint_options_2 = dataInputStream.readInt();
        }
    }

    @Override
    int getFixedLen() {
        return 40;
    }

    @Override
    int getVarLen() {
        return 0;
    }

    final boolean isDebugInitializationSupported() {
        return (this._startup & 0x40000000) != 0;
    }

    final boolean isJobNameSupported() {
        return (this._startup & 0x20000000) != 0;
    }

    final boolean isProgramFilelistSupported() {
        return (this._startup & 0x10000000) != 0;
    }

    final boolean isHostAddressSupported() {
        return (this._startup & 0x8000000) != 0;
    }

    final boolean isViewOrderSupported() {
        return (this._startup & 0x100000) != 0;
    }

    final boolean isStartupSupported() {
        return (this._general_functions & 0x400000) != 0;
    }

    final boolean isProcessListStartupSupported() {
        return (this._general_functions & 0x200000) != 0;
    }

    final boolean isTerminatePGMTypeSupported() {
        return (this._general_functions & 0x20000000) != 0;
    }

    final boolean isMultipleThreadsSupported() {
        return (this._general_functions & Integer.MIN_VALUE) != 0;
    }

    final boolean isPostMortemDebugMode() {
        return (this._general_functions & 0x100000) != 0;
    }

    final boolean isChildProcessSupported() {
        return (this._general_functions & 0x8000000) != 0;
    }

    final boolean isIncludeFilesSupported() {
        return (this._general_functions & 0x4000000) != 0;
    }

    final boolean isDebugOnDemandSupported() {
        return (this._general_functions & 0x800000) != 0;
    }

    final boolean isPostMortemCapableSupported() {
        return (this._general_functions & 0x80000) != 0;
    }

    final boolean isEnhancedStorageSupported() {
        if (this.getEPDCVersion() < 308) {
            return false;
        }
        return (this._general_functions & 0x40000) != 0;
    }

    final boolean isForkFollowBothSupported() {
        if (this.getEPDCVersion() < 310) {
            return false;
        }
        return (this._general_functions & 0x10000000) != 0;
    }

    final boolean isEventContentSupported() {
        return (this._general_functions & 0x1000) != 0;
    }

    final boolean isAsyncSupported() {
        if (this.getEPDCVersion() < 311) {
            return false;
        }
        return (this._general_functions & 0x20000) != 0;
    }

    final boolean isTeamDebugSupported() {
        return (this._general_functions & 0x8000) != 0;
    }

    final boolean isMultipleBreakpointRequestsSupported() {
        return (this._general_functions & 0x2000) != 0;
    }

    final boolean isPlaybackSupported() {
        return (this._general_functions & 0x800) != 0;
    }

    final boolean isEnhancedCCSupported() {
        return (this._general_functions & 0x400) != 0;
    }

    final boolean isCCMixedSupported() {
        return (this._general_functions & 0x200) != 0;
    }

    final boolean isTraceSupported() {
        return (this._general_functions & 8) != 0;
    }

    final boolean isCCSwitchViewWhenMixedSupported() {
        return (this._general_functions & 0x10) != 0;
    }

    final boolean isGetListsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._general_functions & 0x4000) != 0;
    }

    final boolean isChangeSourceFileSupported() {
        if (this.getEPDCEngineSession() != null && this.getEPDCEngineSession().is390() && !this.getEPDCEngineSession().isDBX()) {
            return true;
        }
        return (this._file_options & Integer.MIN_VALUE) != 0;
    }

    final boolean isRestartSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._file_options & 0x40000000) != 0;
    }

    void setProcessAttachSupported(boolean supported) {
        if (supported) {
            this._file_options |= 0x8000000;
        } else if ((this._file_options & 0x8000000) != 0) {
            this._file_options ^= 0x8000000;
        }
    }

    final boolean isProcessAttachSupported() {
        return (this._file_options & 0x8000000) != 0;
    }

    final boolean isProcessDetachSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._file_options & 0x4000000) != 0;
    }

    final boolean isProcessDetachKillSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._file_options & 0x2000000) != 0;
    }

    final boolean isProcessDetachKeepSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._file_options & 0x1000000) != 0;
    }

    final boolean isProcessDetachReleaseSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._file_options & 0x800000) != 0;
    }

    final boolean isLocalSourceFilesSupported() {
        return (this._file_options & 0x200000) != 0;
    }

    final boolean isSearchLocalFirst() {
        return (this._file_options & 0x100000) != 0;
    }

    final boolean isEngineSearchPathUpdateSupported() {
        return (this._file_options & 0x80000) != 0;
    }

    final boolean isModuleSideFileUpdateSupported() {
        return (this._file_options & 0x40000) != 0;
    }

    final boolean isModuleAddSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._file_options & 0x20000000) != 0;
    }

    final boolean isModuleRemoveSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._file_options & 0x10000000) != 0;
    }

    final boolean isStorageEnableDisableSupported() {
        return (this._storage_options & 1) != 0;
    }

    final boolean isLineBreakpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & Integer.MIN_VALUE) != 0;
    }

    final boolean isFunctionBreakpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x20000000) != 0;
    }

    final boolean isAddressBreakpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x10000000) != 0;
    }

    final boolean isAddressRangeBreakpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options_2 & 0x40000000) != 0;
    }

    final boolean isZeroAddressBreakpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options_2 & 0x20000000) != 0;
    }

    final boolean isWatchpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x8000000) != 0;
    }

    final boolean isModuleLoadBreakpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x4000000) != 0;
    }

    final boolean isMacroBreakpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x10) != 0;
    }

    final boolean isMacroGroupBreakpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 8) != 0;
    }

    final boolean isEnhancedWatchpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 4) != 0;
    }

    final boolean isBreakpointSyncAsyncStopControlSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 2) != 0;
    }

    final boolean isBreakpointEnableDisableSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x1000000) != 0;
    }

    final boolean isOccurrenceBreakpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 1) != 0;
    }

    final boolean isBreakpointModifySupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x800000) != 0;
    }

    final boolean isEngineBreakpointSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x200) != 0;
    }

    final boolean isDeferredBreakpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x400000) != 0;
    }

    final boolean isEntryBreakpointsAutoSetSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x200000) != 0;
    }

    final boolean isConditionalBreakpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x100000) != 0;
    }

    final boolean isBreakpointActionsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x20) != 0;
    }

    final boolean isChgaddrConditionalBreakpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x80) != 0;
    }

    final boolean isThreadSpecificBreakpointsOnlySupported() {
        if (this.getEPDCVersion() < 311) {
            return false;
        }
        return (this._breakpoint_options & 0x40) != 0;
    }

    final boolean isBreakpointThreadsSupported() {
        return (this._breakpoint_options & 0x2000) == 0;
    }

    final boolean isBreakpointFrequencySupported() {
        return (this._breakpoint_options & 0x1000) == 0;
    }

    final boolean isMonitor8BytesSupported() {
        return (this._breakpoint_options & 0x80000) != 0;
    }

    final boolean isMonitor4BytesSupported() {
        return (this._breakpoint_options & 0x40000) != 0;
    }

    final boolean isMonitor2BytesSupported() {
        return (this._breakpoint_options & 0x20000) != 0;
    }

    final boolean isMonitor1BytesSupported() {
        return (this._breakpoint_options & 0x10000) != 0;
    }

    final boolean isMonitor0_128BytesSupported() {
        return (this._breakpoint_options & 0x8000) != 0;
    }

    final boolean isMonitorAutoSupported() {
        return (this._breakpoint_options & 0x100) != 0;
    }

    final boolean isDateBreakpointsSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x4000) != 0;
    }

    final boolean isStatementBreakpointSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x40000000) != 0;
    }

    final boolean isAmbiguousBreakpointSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x800) != 0;
    }

    final boolean isAmbiguousAllBreakpointSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options & 0x400) != 0;
    }

    final boolean isExtendedBreakpointFCTSupported() {
        return (this._general_functions & 0x100) != 0;
    }

    final boolean isSourceEntryBreakpointSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._breakpoint_options_2 & Integer.MIN_VALUE) != 0;
    }

    final boolean isMonitorEnableDisableSupported() {
        return (this._monitor_options & Integer.MIN_VALUE) != 0;
    }

    final boolean isMonitorAnyLocalsSupported() {
        return (this._monitor_options & 0x40000000) != 0;
    }

    final boolean isGlobalSymbolsSupported() {
        if (this.getEPDCVersion() < 308) {
            return false;
        }
        return (this._monitor_options & 0x8000000) != 0;
    }

    final boolean isMonitoringExpressionsSupported() {
        return (this._monitor_options & 0x4000000) == 0;
    }

    final boolean isLocalFiltersSupported() {
        if (this.getEPDCVersion() < 308) {
            return false;
        }
        return (this._monitor_options & 0x20000000) != 0;
    }

    final boolean isGlobalListSupported() {
        if (this.getEPDCVersion() < 308) {
            return false;
        }
        return (this._monitor_options & 0x10000000) != 0;
    }

    final boolean isNewMonitorFormatSupported() {
        if (this.getEPDCVersion() < 310) {
            return false;
        }
        return (this._monitor_options & 0x2000000) != 0;
    }

    final boolean isGetNodeExpressionSupported() {
        if (this.getEPDCVersion() < 310) {
            return false;
        }
        return (this._monitor_options & 0x1000000) != 0;
    }

    final boolean isMonitorLocalVariablesSupported() {
        return (this._windows_options & Integer.MIN_VALUE) != 0;
    }

    final boolean isMonitorRegistersSupported() {
        return (this._windows_options & 0x40000000) != 0;
    }

    final boolean isMonitorStackSupported() {
        return (this._windows_options & 0x20000000) != 0;
    }

    final boolean isMonitorStorageSupported() {
        return (this._windows_options & 0x10000000) != 0;
    }

    final boolean isCommandLogSupported() {
        return (this._windows_options & 0x1000000) != 0;
    }

    final boolean isHiddenCommandLogSupported() {
        return (this._windows_options & 0x800000) != 0;
    }

    final boolean isProgramIOSupported() {
        return (this._windows_options & 0x400000) != 0;
    }

    final boolean isModulesViewSupported() {
        if (this.getEPDCVersion() < 308) {
            return true;
        }
        return (this._windows_options & 0x200000) != 0;
    }

    final boolean isThreadFreezeThawSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._run_options & Integer.MIN_VALUE) != 0;
    }

    final boolean isStepOverSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._run_options & 0x40000000) != 0;
    }

    final boolean isStepIntoSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._run_options & 0x20000000) != 0;
    }

    final boolean isStepDebugSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._run_options & 0x10000000) != 0;
    }

    final boolean isStepReturnSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._run_options & 0x8000000) != 0;
    }

    final boolean isRunToLocationSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._run_options & 0x4000000) != 0;
    }

    final boolean isJumpToLocationSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._run_options & 0x2000000) != 0;
    }

    final boolean isHaltSupported() {
        if (this.isPostMortemDebugMode()) {
            return false;
        }
        return (this._run_options & 0x1000000) != 0;
    }

    final boolean isStorageUsageCheckSupported() {
        return (this._run_options & 0x800000) != 0;
    }

    final boolean isExceptionFilterSupported() {
        return (this._exception_options & Integer.MIN_VALUE) != 0;
    }

    final boolean isExceptionExamineSupported() {
        return (this._exception_options & 0x40000000) != 0;
    }

    final boolean isExceptionStepSupported() {
        return (this._exception_options & 0x20000000) != 0;
    }

    final boolean isExceptionRunSupported() {
        return (this._exception_options & 0x10000000) != 0;
    }

    final boolean isStackRemainingSizeSupported() {
        return (this._stack_options & Integer.MIN_VALUE) != 0;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) {
        try {
            EPDC_DumpUtils.NameVal[] startupConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "reserved"), new EPDC_DumpUtils.NameVal(0x40000000, "FCT_DEBUG_APPLICATION_INIT"), new EPDC_DumpUtils.NameVal(0x20000000, "FCT_JOB_NAME"), new EPDC_DumpUtils.NameVal(0x10000000, "FCT_PROGRAM_FILELIST"), new EPDC_DumpUtils.NameVal(0x8000000, "FCT_HOST_ADDRESS"), new EPDC_DumpUtils.NameVal(0x200000, "FCT_FORCE_CLIENT_LICENSE_CHECK"), new EPDC_DumpUtils.NameVal(0x100000, "FCT_VIEWORDER"), new EPDC_DumpUtils.NameVal(1, "FCT_STARTUP_EXTENDED")};
            EPDC_DumpUtils.NameVal[] generalFunctionsConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "FCT_MULTIPLE_THREADS"), new EPDC_DumpUtils.NameVal(0x40000000, "reserved"), new EPDC_DumpUtils.NameVal(0x20000000, "FCT_TERMINATE_TYPE"), new EPDC_DumpUtils.NameVal(0x10000000, "FCT_FORK_FOLLOW_BOTH"), new EPDC_DumpUtils.NameVal(0x8000000, "FCT_CHILD_PROCESSES"), new EPDC_DumpUtils.NameVal(0x4000000, "FCT_INCLUDE_FILES"), new EPDC_DumpUtils.NameVal(0x2000000, "reserved"), new EPDC_DumpUtils.NameVal(0x1000000, "reserved"), new EPDC_DumpUtils.NameVal(0x800000, "FCT_DEBUG_ON_DEMAND"), new EPDC_DumpUtils.NameVal(0x400000, "FCT_STARTUP"), new EPDC_DumpUtils.NameVal(0x200000, "FCT_PROCESS_LIST_STARTUP"), new EPDC_DumpUtils.NameVal(0x100000, "FCT_POST_MORTEM_DEBUG"), new EPDC_DumpUtils.NameVal(524288, "FCT_POST_MORTEM_CAPABLE"), new EPDC_DumpUtils.NameVal(262144, "FCT_ENHANCED_STORAGE"), new EPDC_DumpUtils.NameVal(131072, "FCT_ASYNC_MODE"), new EPDC_DumpUtils.NameVal(65536, "reserved"), new EPDC_DumpUtils.NameVal(32768, "FCT_TEAM_DEBUG"), new EPDC_DumpUtils.NameVal(16384, "FCT_GET_LISTS"), new EPDC_DumpUtils.NameVal(8192, "FCT_MULTIPLE_BREAKPOINT_REQUESTS"), new EPDC_DumpUtils.NameVal(4096, "FCT_EVENT_CONTENT"), new EPDC_DumpUtils.NameVal(2048, "FCT_PLAYBACK"), new EPDC_DumpUtils.NameVal(1024, "FCT_CCENHANCED"), new EPDC_DumpUtils.NameVal(512, "FCT_CCMIXED"), new EPDC_DumpUtils.NameVal(256, "FCT_EXTENDED_BREAKPOINT_FCT"), new EPDC_DumpUtils.NameVal(128, "FCT_CCBRANCH_DECISION"), new EPDC_DumpUtils.NameVal(64, "FCT_CCBRANCH_CONDITION"), new EPDC_DumpUtils.NameVal(32, "FCT_MULTI_REQUEST"), new EPDC_DumpUtils.NameVal(1, "FCT_GENERAL_EXTENDED"), new EPDC_DumpUtils.NameVal(16, "FCT_CCMIXED_SWITCH_VIEW")};
            EPDC_DumpUtils.NameVal[] fileOptionsConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "FCT_CHANGE_SOURCE_FILE"), new EPDC_DumpUtils.NameVal(0x40000000, "FCT_FILE_RESTART"), new EPDC_DumpUtils.NameVal(0x20000000, "FCT_MODULE_ADD"), new EPDC_DumpUtils.NameVal(0x10000000, "FCT_MODULE_REMOVE"), new EPDC_DumpUtils.NameVal(0x8000000, "FCT_PROCESS_ATTACH"), new EPDC_DumpUtils.NameVal(0x4000000, "FCT_PROCESS_DETACH"), new EPDC_DumpUtils.NameVal(0x2000000, "FCT_PROCESS_DETACH_KILL"), new EPDC_DumpUtils.NameVal(0x1000000, "FCT_PROCESS_DETACH_KEEP"), new EPDC_DumpUtils.NameVal(0x800000, "FCT_PROCESS_DETACH_RELEASE"), new EPDC_DumpUtils.NameVal(0x400000, "reserved"), new EPDC_DumpUtils.NameVal(0x200000, "FCT_LOCAL_SOURCE_FILES"), new EPDC_DumpUtils.NameVal(0x100000, "FCT_SEARCH_LOCAL_FIRST"), new EPDC_DumpUtils.NameVal(524288, "FCT_UPDATE_ENGINE_SEARCH_PATH"), new EPDC_DumpUtils.NameVal(262144, "FCT_MODULE_SIDEFILE_UPDATE"), new EPDC_DumpUtils.NameVal(1, "FCT_FILE_EXTENDED")};
            EPDC_DumpUtils.NameVal[] storageOptionsConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "FCT_STORAGE_UPDATE"), new EPDC_DumpUtils.NameVal(1, "FCT_STORAGE_ENABLE_TOGGLE")};
            EPDC_DumpUtils.NameVal[] breakpointOptionsConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "FCT_LINE_BREAKPOINT"), new EPDC_DumpUtils.NameVal(0x40000000, "FCT_STATEMENT_BREAKPOINT"), new EPDC_DumpUtils.NameVal(0x20000000, "FCT_FUNCTION_BREAKPOINT"), new EPDC_DumpUtils.NameVal(0x10000000, "FCT_ADDRESS_BREAKPOINT"), new EPDC_DumpUtils.NameVal(0x8000000, "FCT_CHANGE_ADDRESS_BREAKPOINT"), new EPDC_DumpUtils.NameVal(0x4000000, "FCT_LOAD_BREAKPOINT"), new EPDC_DumpUtils.NameVal(0x2000000, "reserved"), new EPDC_DumpUtils.NameVal(0x1000000, "FCT_BREAKPOINT_ENABLE_TOGGLE"), new EPDC_DumpUtils.NameVal(0x800000, "FCT_BREAKPOINT_MODIFY"), new EPDC_DumpUtils.NameVal(0x400000, "FCT_BREAKPOINT_DEFERRED"), new EPDC_DumpUtils.NameVal(0x200000, "FCT_BREAKPOINT_ENTRY_AUTOSET"), new EPDC_DumpUtils.NameVal(0x100000, "FCT_BREAKPOINT_EXPRESSION"), new EPDC_DumpUtils.NameVal(524288, "FCT_BREAKPOINT_MONITOR_8BYTES"), new EPDC_DumpUtils.NameVal(262144, "FCT_BREAKPOINT_MONITOR_4BYTES"), new EPDC_DumpUtils.NameVal(131072, "FCT_BREAKPOINT_MONITOR_2BYTES"), new EPDC_DumpUtils.NameVal(65536, "FCT_BREAKPOINT_MONITOR_1BYTES"), new EPDC_DumpUtils.NameVal(32768, "FCT_BREAKPOINT_MONITOR_0_128"), new EPDC_DumpUtils.NameVal(16384, "FCT_BREAKPOINT_DATE"), new EPDC_DumpUtils.NameVal(8192, "FCT_BREAKPOINT_NO_THREADS"), new EPDC_DumpUtils.NameVal(4096, "FCT_BREAKPOINT_NO_FREQUENCY"), new EPDC_DumpUtils.NameVal(2048, "FCT_BREAKPOINT_AMBIGUOUS"), new EPDC_DumpUtils.NameVal(1024, "FCT_BREAKPOINT_AMBIGUOUS_ALL"), new EPDC_DumpUtils.NameVal(512, "FCT_ENGINE_BREAKPOINT"), new EPDC_DumpUtils.NameVal(256, "FCT_BREAKPOINT_MONITOR_AUTO"), new EPDC_DumpUtils.NameVal(128, "FCT_BREAKPOINT_CHGADDR_CONDITIONAL"), new EPDC_DumpUtils.NameVal(64, "FCT_BREAKPOINT_THREAD_SPECIFIC_ONLY"), new EPDC_DumpUtils.NameVal(32, "FCT_BREAKPOINT_ACTIONS"), new EPDC_DumpUtils.NameVal(16, "FCT_MACRO_BREAKPOINT"), new EPDC_DumpUtils.NameVal(8, "FCT_MACRO_GROUP_BREAKPOINT"), new EPDC_DumpUtils.NameVal(4, "FCT_CHANGE_ADDRESS_ENHANCED_BREAKPOINT"), new EPDC_DumpUtils.NameVal(2, "FCT_BREAKPOINT_SYNC_ASYNC_STOP_CONTROL"), new EPDC_DumpUtils.NameVal(1, "FCT_OCCURRENCE_BREAKPOINT")};
            EPDC_DumpUtils.NameVal[] breakpointOptions2Constants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "FCT_BREAKPOINT_SOURCE_ENTRY"), new EPDC_DumpUtils.NameVal(0x40000000, "FCT_BREAKPOINT_ADDRESS_RANGE"), new EPDC_DumpUtils.NameVal(0x20000000, "FCT_BREAKPOINT_ZERO_ADDRESS"), new EPDC_DumpUtils.NameVal(1, "FCT_BREAKPOINT2_EXTENDED")};
            EPDC_DumpUtils.NameVal[] monitorOptionsConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "FCT_MONITOR_ENABLE_TOGGLE"), new EPDC_DumpUtils.NameVal(0x40000000, "FCT_MONITOR_ANY_LOCALS"), new EPDC_DumpUtils.NameVal(0x20000000, "FCT_MONITOR_LOCALFILTER"), new EPDC_DumpUtils.NameVal(0x10000000, "FCT_MONITOR_GLOBALLIST"), new EPDC_DumpUtils.NameVal(0x8000000, "FCT_MONITOR_GLOBALSYMBOL"), new EPDC_DumpUtils.NameVal(0x4000000, "FCT_MONITOR_DISABLE_EXPRESSIONS"), new EPDC_DumpUtils.NameVal(0x2000000, "FCT_MONITOR_NEW_FORMAT"), new EPDC_DumpUtils.NameVal(0x1000000, "FCT_GET_NODE_EXPRESSION"), new EPDC_DumpUtils.NameVal(1, "FCT_MONITOR_EXTENDED")};
            EPDC_DumpUtils.NameVal[] windowsOptionsConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "FCT_LOCAL_VARIABLES"), new EPDC_DumpUtils.NameVal(0x40000000, "FCT_REGISTERS"), new EPDC_DumpUtils.NameVal(0x20000000, "FCT_STACK"), new EPDC_DumpUtils.NameVal(0x10000000, "FCT_STORAGE"), new EPDC_DumpUtils.NameVal(0x8000000, "reserved"), new EPDC_DumpUtils.NameVal(0x4000000, "reserved"), new EPDC_DumpUtils.NameVal(0x2000000, "reserved"), new EPDC_DumpUtils.NameVal(0x1000000, "FCT_COMMAND_LOG"), new EPDC_DumpUtils.NameVal(0x800000, "FCT_HIDDEN_COMMAND_LOG"), new EPDC_DumpUtils.NameVal(0x400000, "FCT_PROGRAMIO"), new EPDC_DumpUtils.NameVal(0x200000, "FCT_MODULES_VIEW"), new EPDC_DumpUtils.NameVal(1, "FCT_WINDOW_EXTENDED")};
            EPDC_DumpUtils.NameVal[] runOptionsConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "FCT_THREAD_ENABLED"), new EPDC_DumpUtils.NameVal(0x40000000, "FCT_STEP_OVER"), new EPDC_DumpUtils.NameVal(0x20000000, "FCT_STEP_INTO"), new EPDC_DumpUtils.NameVal(0x10000000, "FCT_STEP_DEBUG"), new EPDC_DumpUtils.NameVal(0x8000000, "FCT_STEP_RETURN"), new EPDC_DumpUtils.NameVal(0x4000000, "FCT_RUN_TO_LOCATION"), new EPDC_DumpUtils.NameVal(0x2000000, "FCT_JUMP_TO_LOCATION"), new EPDC_DumpUtils.NameVal(0x1000000, "FCT_HALT"), new EPDC_DumpUtils.NameVal(0x800000, "FCT_STORAGE_USAGE_CHECK"), new EPDC_DumpUtils.NameVal(0x400000, "FCT_RUN_TO_ENTRY"), new EPDC_DumpUtils.NameVal(0x200000, "FCT_STEP_SKIP_NEXT"), new EPDC_DumpUtils.NameVal(1, "FCT_RUN_EXTENDED")};
            EPDC_DumpUtils.NameVal[] exceptionOptionsConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "FCT_EXCEPTION_FILTER"), new EPDC_DumpUtils.NameVal(0x40000000, "FCT_EXCEPTION_EXAMINE"), new EPDC_DumpUtils.NameVal(0x20000000, "FCT_EXCEPTION_STEP"), new EPDC_DumpUtils.NameVal(0x10000000, "FCT_EXCEPTION_RUN"), new EPDC_DumpUtils.NameVal(1, "FCT_EXCEPTION_EXTENDED")};
            EPDC_DumpUtils.NameVal[] stackOptionsConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "FCT_STACK_REMAINING_SZE"), new EPDC_DumpUtils.NameVal(0x40000000, "FCT_STACK_SET_BREAKPOINT"), new EPDC_DumpUtils.NameVal(0x20000000, "FCT_STACK_OPEN_STORAGE"), new EPDC_DumpUtils.NameVal(1, "FCT_STACK_EXTENDED")};
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Start_UP", this._startup, startupConstants);
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "General_Functions", this._general_functions, generalFunctionsConstants);
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "File_Options", this._file_options, fileOptionsConstants);
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Storage_Options", this._storage_options, storageOptionsConstants);
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Breakpoint_Options", this._breakpoint_options, breakpointOptionsConstants);
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Breakpoint_Options 2", this._breakpoint_options_2, breakpointOptions2Constants);
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Monitor_Options", this._monitor_options, monitorOptionsConstants);
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Windows_Options", this._windows_options, windowsOptionsConstants);
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Run_Options", this._run_options, runOptionsConstants);
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Exception_Options", this._exception_options, exceptionOptionsConstants);
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Stack_Options", this._stack_options, stackOptionsConstants);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getDescription() {
        return "Function Customization Table";
    }

    final boolean isRunToEntrySupported() {
        return (this._run_options & 0x400000) != 0;
    }

    final boolean isLicenseCheckNeeded() {
        return (this._startup & 0x200000) != 0;
    }

    final boolean isMultipleRequestsSupported() {
        return (this._general_functions & 0x20) != 0;
    }

    final boolean isSkipNextSupported() {
        return (this._run_options & 0x200000) != 0;
    }
}

