/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.epdc.IFormattedString;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

class EExtString
extends EPDC_Structures {
    private byte[] _buffer;
    private boolean _specialFormat = false;

    EExtString(String string, EPDC_EngineSession engineSession) {
        super(engineSession);
        if (string != null) {
            try {
                this._buffer = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    EExtString(DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(engineSession);
        int arrayLen = dataInputStream.readInt();
        if (arrayLen < 0) {
            this._specialFormat = true;
            arrayLen = Math.abs(arrayLen);
        }
        this._buffer = new byte[arrayLen];
        dataInputStream.read(this._buffer);
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        dataOutputStream.writeInt(this._buffer.length);
        dataOutputStream.write(this._buffer);
    }

    private boolean isEmpty() {
        return this._buffer == null || this._buffer.length == 0;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        if (!this._specialFormat) {
            try {
                return new String(this._buffer, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
        if (this.getEPDCEngineSession() == null || this.getEPDCEngineSession().getFormattingClass() == null) {
            return "";
        }
        IFormattedString fmtCls = this.getEPDCEngineSession().getFormattingClass();
        try {
            String formattedString = fmtCls.decodeString(this._buffer);
            return formattedString;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    protected int getFixedLen() {
        return 4;
    }

    @Override
    int getVarLen() {
        return this.getLength();
    }

    @Override
    int getTotalBytes() {
        if (this.isEmpty()) {
            return 0;
        }
        return super.getTotalBytes();
    }

    int getLength() {
        if (this._buffer == null) {
            return 0;
        }
        return this._buffer.length;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) {
        try {
            EPDC_DumpUtils.writeVariable(dataOutputStream, String.format("(Len %d)", this._buffer.length), this.toString());
        }
        catch (IOException e) {
            PDTCoreUtils.logError(e);
        }
    }

    @Override
    public String getDescription() {
        return "Extended string";
    }
}

