/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class EEveryClause
extends EPDC_Structures
implements Serializable {
    private int _every;
    private int _to;
    private int _from;
    private static final int FIXED_LENGTH = 12;
    private static final long serialVersionUID = 20050124L;

    public EEveryClause() {
        this._every = 1;
        this._from = 1;
        this._to = 0;
    }

    public EEveryClause(int every, int from, int to) {
        if (every == 0 && to == 0 && from == 0) {
            this._every = 1;
            this._from = 1;
            this._to = 0;
        } else {
            this._every = every;
            this._to = to;
            this._from = from;
        }
    }

    EEveryClause(DataInputStream dataInputStream) throws IOException {
        this._every = dataInputStream.readInt();
        this._to = dataInputStream.readInt();
        this._from = dataInputStream.readInt();
    }

    public int getEveryVal() {
        return this._every;
    }

    public int getToVal() {
        return this._to;
    }

    public int getFromVal() {
        return this._from;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this._every);
        dataOutputStream.writeInt(this._to);
        dataOutputStream.writeInt(this._from);
    }

    @Override
    int getFixedLen() {
        return 12;
    }

    @Override
    int getVarLen() {
        return 0;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) {
        try {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Every_Value", this.getEveryVal());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "To_Value", this.getToVal());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "From_Value", this.getFromVal());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getDescription() {
        return "Every clause";
    }
}

