/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdTraceBinaryEntry;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class ECPTrace
extends EPDC_ChangeItem {
    public static final ECPTrace[] EMPTY = new ECPTrace[0];
    private short fType;
    private int fNumItems;
    private EStdTraceBinaryEntry[] fBinaryTraceItems = null;

    protected ECPTrace(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        this.fType = dataInputStream.readShort();
        if (dataInputStream.skipBytes(2) != 2) {
            PDTCoreUtils.logString(this, "Error reading reserved bits in ECPTrace.", 2);
        }
        this.fNumItems = dataInputStream.readInt();
        switch (this.fType) {
            case 1: {
                this.fBinaryTraceItems = new EStdTraceBinaryEntry[this.fNumItems];
                break;
            }
        }
        int arrayOffset = 0;
        OffsetDataInputStream arrayInputStream = null;
        arrayOffset = dataInputStream.readInt();
        if (arrayOffset != 0) {
            arrayInputStream = new OffsetDataInputStream(byteBuffer, arrayOffset);
        }
        int i = 0;
        while (i < this.fNumItems) {
            switch (this.fType) {
                case 1: {
                    this.fBinaryTraceItems[i] = new EStdTraceBinaryEntry(arrayInputStream, engineSession);
                    break;
                }
                case 2: {
                    break;
                }
            }
            ++i;
        }
    }

    @Override
    int getPacketID() {
        return 19;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] types = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(1, "Binary"), new EPDC_DumpUtils.NameVal(2, "Trace (Unsupported)")};
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Type", EPDC_DumpUtils.getAttrbuteName(types, this.fType));
        if (this.fBinaryTraceItems != null) {
            int i = 0;
            while (i < this.fNumItems) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "[" + i + "] ");
                this.fBinaryTraceItems[i].writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
                ++i;
            }
        }
    }

    @Override
    public String getDescription() {
        return "Trace change item";
    }

    public EStdTraceBinaryEntry[] getBinaryTraceEntries() {
        if (this.fBinaryTraceItems == null) {
            return null;
        }
        return Arrays.copyOf(this.fBinaryTraceItems, this.fBinaryTraceItems.length);
    }
}

