/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EBPList;
import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdAttribute;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ECPThread
extends EPDC_ChangeItem {
    public static final ECPThread[] EMPTY = new ECPThread[0];
    private static final EBPList[] EMPTYBREAKPOINTS = new EBPList[0];
    private short _ThreadDebugState;
    private int _ThreadPriority = 0;
    private String _ThreadName;
    private String _ThreadSystemState;
    private int _ThreadID;
    private EStdView[] _RepWherestop;
    private short _whyStop;
    private String _exceptionMsg;
    private EBPList[] _breakpoints = EMPTYBREAKPOINTS;
    private static final EStdAttribute[] EMPTYATTRIBUTES = new EStdAttribute[0];
    private EStdAttribute[] _attributes = EMPTYATTRIBUTES;

    ECPThread(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        int i;
        int numAttrs = 0;
        if (this.getEPDCVersion() < 307) {
            numAttrs = 3;
            this._attributes = new EStdAttribute[numAttrs];
            this._attributes[0] = new EStdAttribute(2, engineSession._ThreadStateLabel, engineSession._ThreadStateLabels[dataInputStream.readUnsignedShort()], engineSession);
            this._ThreadDebugState = dataInputStream.readShort();
            this._attributes[1] = new EStdAttribute(3, engineSession._ThreadPriorityLabel, String.valueOf(dataInputStream.readInt()), engineSession);
            this._attributes[2] = new EStdAttribute(1, engineSession._ThreadNameLabel, String.valueOf(dataInputStream.readInt()), engineSession);
            this._ThreadID = dataInputStream.readInt();
            dataInputStream.skipBytes(4);
        } else {
            numAttrs = dataInputStream.readUnsignedShort();
            this._ThreadDebugState = dataInputStream.readShort();
            dataInputStream.skipBytes(8);
            this._ThreadID = dataInputStream.readInt();
            if (this.getEPDCVersion() > 310) {
                this._whyStop = dataInputStream.readShort();
                dataInputStream.skipBytes(2);
                int offset = dataInputStream.readInt();
                if (offset != 0) {
                    this._exceptionMsg = new EStdString(new OffsetDataInputStream(byteBuffer, offset), this.getEPDCEngineSession()).toString();
                }
                if ((offset = dataInputStream.readInt()) != 0) {
                    OffsetDataInputStream offsetDataInputStream = new OffsetDataInputStream(byteBuffer, offset);
                    int numBkpts = offsetDataInputStream.readInt();
                    this._breakpoints = new EBPList[numBkpts];
                    int i2 = 0;
                    while (i2 < this._breakpoints.length) {
                        this._breakpoints[i2] = new EBPList(offsetDataInputStream);
                        ++i2;
                    }
                }
            }
            if (numAttrs > 0) {
                this._attributes = new EStdAttribute[numAttrs];
                i = 0;
                while (i < numAttrs) {
                    this._attributes[i] = new EStdAttribute(byteBuffer, dataInputStream, this.getEPDCEngineSession());
                    ++i;
                }
            }
        }
        this.processAttributes();
        switch (this._ThreadDebugState) {
            case 0: {
                this._ThreadDebugState = (short)4;
                break;
            }
            case 3: {
                this._ThreadDebugState = (short)5;
                break;
            }
        }
        this._RepWherestop = new EStdView[engineSession.getNumViews() + 1];
        this._RepWherestop[0] = null;
        i = 1;
        while (i < this._RepWherestop.length) {
            this._RepWherestop[i] = new EStdView(dataInputStream);
            ++i;
        }
    }

    public short getDebugState() {
        return this._ThreadDebugState;
    }

    public int getPriority() {
        return this._ThreadPriority;
    }

    public String getName() {
        return this._ThreadName;
    }

    public String getSystemState() {
        return this._ThreadSystemState;
    }

    public int getId() {
        return this._ThreadID;
    }

    public short getWhyStop() {
        return this._whyStop;
    }

    public String getExceptionMsg() {
        return this._exceptionMsg;
    }

    public EBPList[] getBreakpointList() {
        return this._breakpoints;
    }

    public boolean isTerminated() {
        return this._ThreadDebugState == 2;
    }

    public EStdView[] getStoppingLocations() {
        return this._RepWherestop;
    }

    public EStdAttribute[] getAttributes() {
        int i = 0;
        while (i < this._attributes.length) {
            EStdAttribute attribute = this._attributes[i];
            if (attribute.getName() == null || attribute.getName().length() == 0) {
                switch (attribute.getType()) {
                    case 1: {
                        attribute.setName(this.getEPDCEngineSession()._ThreadNameLabel);
                        break;
                    }
                    case 3: {
                        attribute.setName(this.getEPDCEngineSession()._ThreadPriorityLabel);
                        break;
                    }
                    case 2: {
                        attribute.setName(this.getEPDCEngineSession()._ThreadStateLabel);
                        break;
                    }
                    case 5: {
                        attribute.setName(this.getEPDCEngineSession()._ThreadBlockingThreadLabel);
                        break;
                    }
                    case 4: {
                        attribute.setName(this.getEPDCEngineSession()._ThreadGroupLabel);
                        break;
                    }
                }
            }
            ++i;
        }
        return this._attributes;
    }

    private void processAttributes() {
        int i = 0;
        while (i < this._attributes.length) {
            EStdAttribute attribute = this._attributes[i];
            switch (attribute.getType()) {
                case 1: {
                    this._ThreadName = attribute.getValue();
                    break;
                }
                case 3: {
                    try {
                        this._ThreadPriority = Integer.parseInt(attribute.getValue());
                    }
                    catch (NumberFormatException excp) {
                        this._ThreadPriority = 0;
                    }
                    break;
                }
                case 2: {
                    this._ThreadSystemState = attribute.getValue();
                    break;
                }
            }
            ++i;
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) {
        try {
            int i;
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Current_Debug_State", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "StdThd.*", this._ThreadDebugState));
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Thread_ID", this._ThreadID);
            if (this.getEPDCVersion() > 310) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "whyStop", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "Why_.*", this._whyStop));
                if (this._exceptionMsg != null) {
                    EPDC_DumpUtils.writeVariable(dataOutputStream, "Exception message", this._exceptionMsg);
                } else {
                    EPDC_DumpUtils.writeVariable(dataOutputStream, "Exception message", "NULL");
                }
            }
            if (this._attributes != null) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Of_Attributes", this._attributes.length);
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Attributes");
                i = 0;
                while (i < this._attributes.length) {
                    if (this._attributes[i] != null) {
                        EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i + "]");
                        this._attributes[i].writeEPDC(dataOutputStream);
                        EPDC_DumpUtils.endStructure(dataOutputStream);
                    }
                    ++i;
                }
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Of_Attributes", 0);
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Attributes", "NULL");
            }
            if (this._RepWherestop != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Views");
                i = 0;
                while (i < this._RepWherestop.length) {
                    if (this._RepWherestop[i] != null) {
                        EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i + "]");
                        this._RepWherestop[i].writeEPDC(dataOutputStream);
                        EPDC_DumpUtils.endStructure(dataOutputStream);
                    }
                    ++i;
                }
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Views", "NULL");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getDescription() {
        return "Thread change item";
    }

    @Override
    int getPacketID() {
        return 3;
    }
}

