/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.ERepGetNextMonitorStorageLine;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdStorageLocation;
import com.ibm.debug.pdt.internal.epdc.EStdStorageRange;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

@Deprecated
public class ECPStorage
extends EPDC_ChangeItem {
    public static final ECPStorage[] EMPTY = new ECPStorage[0];
    private int _id;
    private EStdStorageRange _range;
    private EStdStorageLocation _location;
    private EStdExpression2 _expr;
    private short _unitStyle;
    private int _unitCount;
    private int _firstAddress;
    private int _secondAddress;
    private int _firstContents;
    private int _secondContents;
    private int _attributeIndex;
    private short _flags;
    private ERepGetNextMonitorStorageLine[] _lines;

    ECPStorage(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        this._id = dataInputStream.readUnsignedShort();
        this._range = new EStdStorageRange(dataInputStream);
        this._location = new EStdStorageLocation(byteBuffer, dataInputStream, engineSession);
        int offset = dataInputStream.readInt();
        if (offset > 0) {
            this._expr = new EStdExpression2(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._unitStyle = dataInputStream.readShort();
        this._unitCount = dataInputStream.readInt();
        dataInputStream.skipBytes(2);
        this._firstAddress = dataInputStream.readInt();
        this._secondAddress = dataInputStream.readInt();
        this._firstContents = dataInputStream.readInt();
        this._secondContents = dataInputStream.readInt();
        this._attributeIndex = dataInputStream.readInt();
        int numberOfLines = dataInputStream.readInt();
        this._flags = dataInputStream.readShort();
        offset = dataInputStream.readInt();
        if (numberOfLines > 0 && offset != 0) {
            this._lines = new ERepGetNextMonitorStorageLine[numberOfLines];
            OffsetDataInputStream offsetDataInputStream = new OffsetDataInputStream(byteBuffer, offset);
            int i = 0;
            while (i < numberOfLines) {
                this._lines[i] = new ERepGetNextMonitorStorageLine(byteBuffer, offsetDataInputStream, this, engineSession);
                ++i;
            }
        }
    }

    public int getFirstLineOffset() {
        return this._range.getFirstLineOffset();
    }

    public int getLastLineOffset() {
        return this._range.getLastLineOffset();
    }

    public String getAddress() {
        return this._location.getAddress();
    }

    public int id() {
        return this._id;
    }

    public boolean isNew() {
        return (this._flags & 0x4000) != 0;
    }

    public boolean isDeleted() {
        return (this._flags & 0x8000) != 0;
    }

    public boolean styleChanged() {
        return (this._flags & 0x10) != 0;
    }

    public boolean addressChanged() {
        return (this._flags & 0x400) != 0;
    }

    public boolean isEnabled() {
        return (this._flags & 0x2000) != 0;
    }

    public boolean exprIsEnabled() {
        return (this._flags & 0x40) != 0;
    }

    public ERepGetNextMonitorStorageLine[] getLines() {
        return this._lines;
    }

    int beginAddress() {
        return this._firstAddress;
    }

    int endAddress() {
        return this._secondAddress;
    }

    int beginStorage() {
        return this._firstContents;
    }

    int endStorage() {
        return this._secondContents;
    }

    public int unitCount() {
        return this._unitCount;
    }

    int attributeIndex() {
        return this._attributeIndex;
    }

    public short getUnitStyle() {
        return this._unitStyle;
    }

    public EStdExpression2 getExpression() {
        return this._expr;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) {
        EPDC_DumpUtils.NameVal[] monStor = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(32768, "MonStorDeleted"), new EPDC_DumpUtils.NameVal(16384, "MonStorNew"), new EPDC_DumpUtils.NameVal(8192, "MonStorEnabled"), new EPDC_DumpUtils.NameVal(4096, "MonStorEnablementChanged"), new EPDC_DumpUtils.NameVal(2048, "MonStorContentsChanged"), new EPDC_DumpUtils.NameVal(1024, "MonStorAddressChanged"), new EPDC_DumpUtils.NameVal(512, "MonStorStartBoundry"), new EPDC_DumpUtils.NameVal(256, "MonStorEndBoundry"), new EPDC_DumpUtils.NameVal(128, "MonStorNewLinesReturned"), new EPDC_DumpUtils.NameVal(64, "MonStorExprEnabled"), new EPDC_DumpUtils.NameVal(32, "MonStorExprNotAllocated"), new EPDC_DumpUtils.NameVal(16, "MonStorStyleChanged")};
        try {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Monitor_Storage_ID", this.id());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage_Unit_Style", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "StorageStyle.*", this.getUnitStyle()));
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage_Unit_Count", this.unitCount());
            try {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage_Address_Style", this.getAddress());
            }
            catch (Exception e) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage_Address_Style", "NULL");
            }
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Address_Field1_Index", this.beginAddress());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Address_Field2_Index", this.endAddress());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Unit_Field1_Index", this.beginStorage());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Unit_Field2_Index", this.endStorage());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Attribute_Index", this.attributeIndex());
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Flags", this._flags, monStor);
            if (this._range != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Storage_Range");
                this._range.writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage_Range", "NULL");
            }
            if (this._location != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Base_Location");
                this._location.writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Base_Location", "NULL");
            }
            if (this._expr != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Storage_Expr");
                this._expr.writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage_Expr", "NULL");
            }
            if (this._lines != null) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Changed_Lines", this._lines.length);
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Storage_Line_offset");
                int i = 0;
                while (i < this._lines.length) {
                    if (this._lines[i] != null) {
                        EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i + "]");
                        this._lines[i].writeEPDC(dataOutputStream);
                        EPDC_DumpUtils.endStructure(dataOutputStream);
                    }
                    ++i;
                }
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Changed_Lines", 0);
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage_Line_offset", "NULL");
            }
        }
        catch (IOException e) {
            PDTCoreUtils.logError(e);
        }
    }

    @Override
    public String getDescription() {
        return "(Deprecated) Storage change item";
    }

    @Override
    int getPacketID() {
        return 9;
    }
}

