/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.ERepGetNextStackEntry;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class ECPStack
extends EPDC_ChangeItem {
    public static final ECPStack[] EMPTY = new ECPStack[0];
    private int _threadID;
    private int _stackStatus;
    private int _oldestChangedEntry;
    private Vector<ERepGetNextStackEntry> _stackEntries;

    ECPStack(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        this._threadID = dataInputStream.readInt();
        int numberOfStackEntries = dataInputStream.readInt();
        this._oldestChangedEntry = dataInputStream.readInt();
        this._stackStatus = dataInputStream.readInt();
        if (this._stackStatus != 1) {
            this._stackEntries = new Vector(numberOfStackEntries);
            int numberOfStackEntriesInThisPacket = numberOfStackEntries - this._oldestChangedEntry + 1;
            if (!engineSession.isiSeriesEngine() && numberOfStackEntries == 1 || engineSession.isiSeriesEngine() && numberOfStackEntriesInThisPacket == 1) {
                ERepGetNextStackEntry stackEntry = new ERepGetNextStackEntry(byteBuffer, dataInputStream, engineSession);
                if (engineSession.useStackEntryIndex()) {
                    stackEntry.setIndex(1);
                }
                if (engineSession.reverseStackEntries()) {
                    this._stackEntries.insertElementAt(stackEntry, 0);
                } else {
                    this._stackEntries.addElement(stackEntry);
                }
            } else {
                int idx = 1;
                while (idx <= numberOfStackEntriesInThisPacket) {
                    int _offset = dataInputStream.readInt();
                    if (_offset != 0) {
                        ERepGetNextStackEntry stackEntry = new ERepGetNextStackEntry(byteBuffer, new OffsetDataInputStream(byteBuffer, _offset), engineSession);
                        if (engineSession.useStackEntryIndex()) {
                            stackEntry.setIndex(idx);
                        }
                        if (engineSession.reverseStackEntries()) {
                            this._stackEntries.insertElementAt(stackEntry, 0);
                        } else {
                            this._stackEntries.addElement(stackEntry);
                        }
                    }
                    ++idx;
                }
            }
        }
    }

    public int getThreadID() {
        return this._threadID;
    }

    public int getOldestChangedEntry() {
        return this._oldestChangedEntry;
    }

    public ERepGetNextStackEntry[] getStackEntries() {
        return this._stackEntries.toArray(new ERepGetNextStackEntry[this._stackEntries.size()]);
    }

    public boolean isNewStack() {
        return (this._stackStatus & 2) != 0;
    }

    public boolean isStackDeleted() {
        return (this._stackStatus & 1) != 0;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) {
        EPDC_DumpUtils.NameVal[] statusConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(4, "STACK_CHANGED"), new EPDC_DumpUtils.NameVal(2, "STACK_NEW"), new EPDC_DumpUtils.NameVal(1, "STACK_DELETE"), new EPDC_DumpUtils.NameVal(0, "STACK_NOCHANGE")};
        try {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Thread ID", this.getThreadID());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_OldestChange_entry", this.getOldestChangedEntry());
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Reason_for_Entry", this._stackStatus, statusConstants);
            if (this._stackEntries != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Stack_Entries");
                int i = 0;
                while (i < this._stackEntries.size()) {
                    if (this._stackEntries.get(i) != null) {
                        EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i + "]");
                        this._stackEntries.get(i).writeEPDC(dataOutputStream);
                        EPDC_DumpUtils.endStructure(dataOutputStream);
                    }
                    ++i;
                }
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Stack_Entries", "NULL");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getDescription() {
        return "Stack change item";
    }

    @Override
    int getPacketID() {
        return 10;
    }
}

