/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ECPRegister
extends EPDC_ChangeItem {
    public static final ECPRegister[] EMPTY = new ECPRegister[0];
    private int _threadID;
    private int _groupID;
    private int _registerID;
    private EStdString _name;
    private EStdString _value;
    private int _flags;
    private int _type;

    ECPRegister(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        this._threadID = dataInputStream.readInt();
        this._groupID = dataInputStream.readInt();
        this._registerID = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._name = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._value = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._flags = dataInputStream.readInt();
        this._type = dataInputStream.readInt();
    }

    public int getThreadID() {
        return this._threadID;
    }

    public int getGroupID() {
        return this._groupID;
    }

    public int getRegisterID() {
        return this._registerID;
    }

    public String getName() {
        if (this._name != null) {
            return this._name.toString();
        }
        return "";
    }

    public String getValue() {
        if (this._value != null) {
            return this._value.toString();
        }
        return "";
    }

    public int getFlags() {
        return this._flags;
    }

    public boolean isNew() {
        return (this._flags & 0x40000000) != 0;
    }

    public boolean isDeleted() {
        return (this._flags & Integer.MIN_VALUE) != 0;
    }

    public int getType() {
        return this._type;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) {
        EPDC_DumpUtils.NameVal[] registerConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "RegisterDeleted"), new EPDC_DumpUtils.NameVal(0x40000000, "RegisterNew"), new EPDC_DumpUtils.NameVal(0x20000000, "RegisterNameChanged"), new EPDC_DumpUtils.NameVal(0x10000000, "RegisterValueChanged")};
        try {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "RegistersDU", this.getThreadID());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Registers_GroupID", this.getGroupID());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Register_ID", this.getRegisterID());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Register_Name", this.getName());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Register_Value", this.getValue());
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Register_Flags", this.getFlags(), registerConstants);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Register_Type", this.getType());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getDescription() {
        return "Register change item (" + this.getName() + ")";
    }

    @Override
    int getPacketID() {
        return 14;
    }
}

