/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EViewData;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ECPPart
extends EPDC_ChangeItem {
    public static final ECPPart[] EMPTY = new ECPPart[0];
    private int _Partid;
    private byte _PartAttr;
    private byte _PartLang;
    private EStdString _PartName;
    private EStdString _PartFileName;
    private EStdString _PartPathName;
    private int _ModuleID;
    private EViewData[] _Viewdata;

    ECPPart(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        this._Partid = dataInputStream.readUnsignedShort();
        this._PartAttr = dataInputStream.readByte();
        this._PartLang = dataInputStream.readByte();
        dataInputStream.skipBytes(4);
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._PartName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._PartFileName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._PartPathName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._ModuleID = dataInputStream.readInt();
        this._Viewdata = new EViewData[engineSession.getNumViews() + 1];
        int i = 1;
        while (i < this._Viewdata.length) {
            this._Viewdata[i] = new EViewData(byteBuffer, dataInputStream, engineSession);
            ++i;
        }
    }

    public int getId() {
        return this._Partid;
    }

    public String getName() {
        if (this._PartName != null) {
            return this._PartName.toString();
        }
        return null;
    }

    public String getPathName() {
        if (this._PartPathName != null) {
            return this._PartPathName.toString();
        }
        return null;
    }

    public String getFileName() {
        if (this._PartFileName != null) {
            return this._PartFileName.toString();
        }
        return null;
    }

    public int getModuleID() {
        return this._ModuleID;
    }

    public boolean isDeletedPart() {
        return (this._PartAttr & 0x10) != 0;
    }

    public void setDeleted() {
        this._PartAttr = (byte)(this._PartAttr | 0x10);
    }

    public boolean isNewPart() {
        return (this._PartAttr & 0x20) != 0;
    }

    public boolean hasBeenVerified() {
        return (this._PartAttr & 0x40) != 0;
    }

    public byte getLanguage() {
        return this._PartLang;
    }

    public boolean isDebuggable() {
        return (this._PartAttr & 2) != 0;
    }

    public EViewData[] getViews() {
        return this._Viewdata;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) {
        EPDC_DumpUtils.NameVal[] attrConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(128, "InUse"), new EPDC_DumpUtils.NameVal(64, "Verified"), new EPDC_DumpUtils.NameVal(32, "New"), new EPDC_DumpUtils.NameVal(8, "Changed"), new EPDC_DumpUtils.NameVal(16, "Deleted"), new EPDC_DumpUtils.NameVal(2, "SymbolTbl")};
        try {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "ID", this.getId());
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Attr", this._PartAttr, attrConstants);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Lang", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "LANG_.*", this.getLanguage()));
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Name", this.getName());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "FileName", this.getFileName());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "PathName", this.getPathName());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Module_ID", this.getModuleID());
            if (this._Viewdata != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Views");
                int i = 0;
                while (i < this._Viewdata.length) {
                    if (this._Viewdata[i] != null) {
                        EPDC_DumpUtils.beginStructure(dataOutputStream, "[" + i + "]");
                        this._Viewdata[i].writeEPDC(dataOutputStream);
                        EPDC_DumpUtils.endStructure(dataOutputStream);
                    }
                    ++i;
                }
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Views", "NULL");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getDescription() {
        return "Part change item";
    }

    @Override
    int getPacketID() {
        return 1;
    }
}

