/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public abstract class ECPMonitorExprBase
extends EPDC_ChangeItem
implements Serializable {
    public static final ECPMonitorExprBase[] EMPTY = new ECPMonitorExprBase[0];
    protected transient short _flags;
    protected transient int _stackID;
    protected transient int _functionID;
    protected transient int _ID;
    protected int _threadID;
    protected short _type;
    protected EStdView _exprContext;
    protected EStdString _stmtNum;
    protected EStdString _exprString;
    protected EStdString _moduleName;
    protected EStdString _partName;
    protected EStdString _viewFileName;
    private static final long serialVersionUID = 20051011L;

    ECPMonitorExprBase(EPDC_EngineSession engineSession) {
        super(engineSession);
    }

    ECPMonitorExprBase(byte[] byteBuffer, EPDC_EngineSession engineSession) {
        super(byteBuffer, engineSession);
    }

    public boolean isNewMonitor() {
        return (this._flags & 0x4000) != 0;
    }

    public boolean isDeleted() {
        return (this._flags & 0x8000) != 0;
    }

    public boolean isDisabled() {
        return (this._flags & 0x1000) == 0;
    }

    public boolean isPending() {
        return (this._flags & 0x10) != 0;
    }

    public boolean isEnabled() {
        return (this._flags & 0x1000) != 0;
    }

    public boolean isDeferred() {
        return (this._flags & 0x40) != 0;
    }

    public boolean isSaveable() {
        return (this._flags & 8) == 0;
    }

    public int getId() {
        return this._ID;
    }

    public EStdView getContext() {
        return this._exprContext;
    }

    public short getType() {
        return this._type;
    }

    public int getThreadID() {
        return this._threadID;
    }

    public String getExpressionString() {
        if (this._exprString == null) {
            return null;
        }
        return this._exprString.toString();
    }

    public String getModuleName() {
        if (this._moduleName == null) {
            return null;
        }
        return this._moduleName.toString();
    }

    public String getPartName() {
        if (this._partName == null) {
            return null;
        }
        return this._partName.toString();
    }

    public String getFileName() {
        if (this._viewFileName == null) {
            return null;
        }
        return this._viewFileName.toString();
    }

    public String getStmtNumber() {
        if (this._stmtNum == null) {
            return null;
        }
        return this._stmtNum.toString();
    }

    public boolean isReadOnly() {
        return (this._flags & 0x20) != 0;
    }

    public int getStackFrameID() {
        return this._stackID;
    }

    public int getEntryID() {
        return this._functionID;
    }

    public boolean isEnablementChanged() {
        return (this._flags & 0x200) != 0;
    }

    public boolean isMonValueChanged() {
        return (this._flags & 0x800) != 0;
    }

    public boolean isMonTreeStructChanged() {
        return (this._flags & 0x400) != 0;
    }

    public void forceMonTreeStructChangedFlag() {
        this._flags = (short)(this._flags | 0x400);
    }

    public boolean isLocalVariable() {
        return this._type == 3;
    }

    public boolean isPopup() {
        return this._type == 2;
    }

    public boolean isSame(ECPMonitorExprBase expr) {
        if (expr.getExpressionString() == null || expr.getExpressionString().compareTo(this.getExpressionString()) != 0) {
            return false;
        }
        if (expr._type != this._type) {
            return false;
        }
        if (expr.getModuleName() == null || expr.getModuleName().compareTo(this.getModuleName()) != 0) {
            return false;
        }
        if (expr.getPartName() == null || expr.getPartName().compareTo(this.getPartName()) != 0) {
            return false;
        }
        return expr.getFileName() != null && expr.getFileName().compareTo(this.getFileName()) == 0;
    }

    public boolean hasChanged() {
        return this.isMonTreeStructChanged() || this.isMonValueChanged() || this.isEnablementChanged();
    }

    public abstract boolean isValid();

    public void writeFlags(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] constants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(32768, "MonDeleted"), new EPDC_DumpUtils.NameVal(16384, "MonNew"), new EPDC_DumpUtils.NameVal(4096, "MonEnabled"), new EPDC_DumpUtils.NameVal(2048, "MonValuesChanged"), new EPDC_DumpUtils.NameVal(1024, "MonTreeStructChanged"), new EPDC_DumpUtils.NameVal(512, "MonEnablementChanged"), new EPDC_DumpUtils.NameVal(8, "MonDoNotRestore"), new EPDC_DumpUtils.NameVal(64, "MonDeferred"), new EPDC_DumpUtils.NameVal(32, "MonReadOnly")};
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Flags", this._flags, constants);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        try {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "ExpressionString", this.getExpressionString());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Type", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "MonType.*", this._type));
            EPDC_DumpUtils.writeVariable(dataOutputStream, "ModuleEntryID", this.getEntryID());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "ModuleName", this.getModuleName());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "ViewFileName", this.getFileName());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "PartName", this.getPartName());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "getStackID", this.getStackFrameID());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "stmtNumber", this.getStmtNumber());
            if (this._exprContext != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, this._exprContext.getDescription());
                this._exprContext.writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "exprContext", "NULL");
            }
            this.writeFlags(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    int getPacketID() {
        return 4;
    }
}

