/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.ECPMonitorExprBase;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdExprNode;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ECPMonitorExpr2
extends ECPMonitorExprBase {
    private transient int _numExprNodes;
    private transient int _offsetExprNodes;
    private transient int _numActionLabels;
    private transient int _offsetActionLabels;
    private transient int _numPropertyLabels;
    private transient int _offsetPropertyLabels;
    private transient String[] _actionLabels;
    private transient String[] _propertyLabels;
    private transient EStdExprNode[] _exprNodes;
    private transient int _engineData;
    private static final EStdExprNode[] EMPTYNODES = new EStdExprNode[0];
    private static final long serialVersionUID = 20051011L;

    public ECPMonitorExpr2(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        int offset = 0;
        this._ID = dataInputStream.readInt();
        this._flags = dataInputStream.readShort();
        this._type = dataInputStream.readShort();
        offset = dataInputStream.readInt();
        if (offset != 0) {
            this._exprString = new EStdString(new OffsetDataInputStream(byteBuffer, offset), this.getEPDCEngineSession());
        }
        this._numExprNodes = dataInputStream.readInt();
        this._offsetExprNodes = dataInputStream.readInt();
        offset = dataInputStream.readInt();
        if (offset != 0) {
            this._stmtNum = new EStdString(new OffsetDataInputStream(byteBuffer, offset), this.getEPDCEngineSession());
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._exprContext = new EStdView(new OffsetDataInputStream(byteBuffer, offset));
        }
        this._threadID = dataInputStream.readInt();
        this._stackID = dataInputStream.readUnsignedShort();
        this._functionID = dataInputStream.readInt();
        offset = dataInputStream.readInt();
        if (offset != 0) {
            this._moduleName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), this.getEPDCEngineSession());
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._partName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), this.getEPDCEngineSession());
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._viewFileName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), this.getEPDCEngineSession());
        }
        this._numActionLabels = dataInputStream.readUnsignedShort();
        this._offsetActionLabels = dataInputStream.readInt();
        this._numPropertyLabels = dataInputStream.readUnsignedShort();
        this._offsetPropertyLabels = dataInputStream.readInt();
        this._engineData = dataInputStream.readInt();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getActionLabel(int idx) {
        if (idx + 1 > this._numActionLabels) {
            return "Invalid action label index (" + idx + ")";
        }
        if (this._actionLabels != null) {
            return this._actionLabels[idx];
        }
        if (this._numActionLabels == 0) {
            return "No action labels";
        }
        this._actionLabels = new String[this._numActionLabels];
        try {
            var2_2 = null;
            var3_5 = null;
            try {
                dis = new OffsetDataInputStream(this.getByteBuffer(), this._offsetActionLabels);
                try {
                    i = 0;
                    while (true) {
                        try {
                            this._actionLabels[i] = new EStdString(dis, this.getEPDCEngineSession()).toString();
                        }
                        catch (IOException e) {
                            if (dis == null) return "Error getting action labels";
                            dis.close();
                            return "Error getting action labels";
                        }
                        ++i;
                        return i;
                    }
                }
                finally {
                    if (i < this._numActionLabels) ** continue;
                    return this._actionLabels[idx];
                }
            }
            catch (Throwable var3_6) {
                if (var2_2 == null) {
                    var2_2 = var3_6;
                    throw var2_2;
                }
                if (var2_2 == var3_6) throw var2_2;
                var2_2.addSuppressed(var3_6);
                throw var2_2;
            }
        }
        catch (IOException var2_4) {
            // empty catch block
        }
        return this._actionLabels[idx];
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPropertyLabel(int idx) {
        if (idx + 1 > this._numPropertyLabels) {
            return "Invalid property label index (" + idx + ")";
        }
        if (this._propertyLabels != null) {
            return this._propertyLabels[idx];
        }
        if (this._numPropertyLabels == 0) {
            return "No property Labels";
        }
        this._propertyLabels = new String[this._numPropertyLabels];
        try {
            var2_2 = null;
            var3_5 = null;
            try {
                dis = new OffsetDataInputStream(this.getByteBuffer(), this._offsetPropertyLabels);
                try {
                    i = 0;
                    while (true) {
                        try {
                            this._propertyLabels[i] = new EStdString(dis, this.getEPDCEngineSession()).toString();
                        }
                        catch (IOException e) {
                            if (dis == null) return "Error getting property labels";
                            dis.close();
                            return "Error getting property labels";
                        }
                        ++i;
                        return i;
                    }
                }
                finally {
                    if (i < this._numPropertyLabels) ** continue;
                    return this._propertyLabels[idx];
                }
            }
            catch (Throwable var3_6) {
                if (var2_2 == null) {
                    var2_2 = var3_6;
                    throw var2_2;
                }
                if (var2_2 == var3_6) throw var2_2;
                var2_2.addSuppressed(var3_6);
                throw var2_2;
            }
        }
        catch (IOException var2_4) {
            // empty catch block
        }
        return this._propertyLabels[idx];
    }

    /*
     * Unable to fully structure code
     */
    public EStdExprNode[] getExprNodes() {
        if (this._exprNodes != null) {
            return this._exprNodes;
        }
        if (this._numExprNodes == 0) {
            this._exprNodes = ECPMonitorExpr2.EMPTYNODES;
            return ECPMonitorExpr2.EMPTYNODES;
        }
        this._exprNodes = new EStdExprNode[this._numExprNodes];
        try {
            var1_1 = null;
            var2_4 = null;
            try {
                dis = new OffsetDataInputStream(this.getByteBuffer(), this._offsetExprNodes);
                try {
                    i = 0;
                    while (true) {
                        try {
                            this._exprNodes[i] = new EStdExprNode(this.getByteBuffer(), dis, this.getEPDCEngineSession());
                        }
                        catch (IOException e) {
                            this._exprNodes = ECPMonitorExpr2.EMPTYNODES;
                            if (dis != null) {
                                dis.close();
                            }
                            return ECPMonitorExpr2.EMPTYNODES;
                        }
                        ++i;
                        return i;
                    }
                }
                finally {
                    if (i < this._numExprNodes) ** continue;
                }
            }
            catch (Throwable var2_5) {
                if (var1_1 == null) {
                    var1_1 = var2_5;
                } else if (var1_1 != var2_5) {
                    var1_1.addSuppressed(var2_5);
                }
                throw var1_1;
            }
        }
        catch (IOException var1_3) {
            // empty catch block
        }
        return this._exprNodes;
    }

    public int getEngineData() {
        return this._engineData;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        int i;
        EPDC_DumpUtils.writeVariable(dataOutputStream, "MonitorExprID", this.getId());
        this.writeFlags(dataOutputStream);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "MonitorType", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "MonType.*", this._type));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "MonitorExprString", this.getExpressionString());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "NumNodes", this.getExprNodes().length);
        EPDC_DumpUtils.beginStructure(dataOutputStream, "ExprNodes");
        int n = 0;
        while (n < this.getExprNodes().length) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "ExprNodes[" + n + "]");
            this.getExprNodes()[n].writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
            ++n;
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "MonitorExprStmtNum", this.getStmtNumber());
        if (this._exprContext != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, this._exprContext.getDescription());
            this._exprContext.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "MonitorExprContext", "NULL");
        }
        EPDC_DumpUtils.writeVariable(dataOutputStream, "MonitorExprDU", this.getThreadID());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "MonitorStackFrameID", this.getStackFrameID());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "MonitorEntryID", this.getEntryID());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ModuleName", this.getModuleName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "PartName", this.getPartName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ViewFileName", this.getFileName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "NumActionLabels", this._numActionLabels);
        if (this._numActionLabels > 0) {
            this.getActionLabel(0);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "ActionLabels");
            i = 0;
            while (i < this._actionLabels.length) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "ActionLabel[" + i + "]", this._actionLabels[i]);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        }
        EPDC_DumpUtils.writeVariable(dataOutputStream, "NumPropertyLabels", this._numPropertyLabels);
        if (this._numPropertyLabels > 0) {
            this.getPropertyLabel(0);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "PropertyLabels");
            i = 0;
            while (i < this._propertyLabels.length) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "PropertyLabel[" + i + "]", this._propertyLabels[i]);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        }
        EPDC_DumpUtils.writeVariable(dataOutputStream, "EngineData", this._engineData);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Expression change item (310+)";
    }
}

