/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.ECPMonitorExprBase;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdTreeNode;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ECPMonitorExpr
extends ECPMonitorExprBase {
    private transient EStdTreeNode _exprTree;
    private transient int _parentMonitorExprID = 0;
    private static final long serialVersionUID = 20070212L;

    public ECPMonitorExpr(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        this._ID = dataInputStream.readUnsignedShort();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._exprTree = new EStdTreeNode(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), this.getEPDCEngineSession());
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._exprContext = new EStdView(new OffsetDataInputStream(byteBuffer, offset));
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._stmtNum = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._exprString = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._threadID = dataInputStream.readInt();
        this._parentMonitorExprID = dataInputStream.readUnsignedShort();
        this._flags = dataInputStream.readShort();
        this._stackID = dataInputStream.readUnsignedShort();
        this._type = dataInputStream.readShort();
        this._functionID = dataInputStream.readInt();
        offset = dataInputStream.readInt();
        if (offset != 0) {
            this._moduleName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._partName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._viewFileName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public EStdTreeNode getExprTree() {
        return this._exprTree;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        super.writeEPDC(dataOutputStream);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Monitor_Expr_ID", this.getId());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Monitor_Expr_DU", this.getThreadID());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Parent_Monitor_Expr", this._parentMonitorExprID);
        if (this.getExprTree() != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Monitor_Expr_Tree");
            this.getExprTree().writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Monitor_Ecpr_Tree", "NULL");
        }
    }

    @Override
    public boolean isValid() {
        if (this._exprTree == null && this.isDeleted()) {
            return true;
        }
        return this._exprTree != null;
    }

    @Override
    public String getDescription() {
        return "(Deprecated) Expression change item (<310)";
    }
}

