/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ECPModule
extends EPDC_ChangeItem {
    public static final ECPModule[] EMPTY = new ECPModule[0];
    private int _Flags;
    private int _ModuleID;
    private EStdString _ModuleName;
    private EStdString _FullPathModuleName;
    private EStdString _ModuleInformationalMessage;

    ECPModule(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        this._Flags = dataInputStream.readByte();
        this._ModuleID = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._ModuleName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._FullPathModuleName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if (this.getEPDCEngineSession().supportsModuleSideFileUpdate()) {
            offset = dataInputStream.readInt();
            if (offset != 0) {
                this._ModuleInformationalMessage = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
            }
        } else {
            dataInputStream.skipBytes(4);
        }
    }

    public boolean isNewModule() {
        return (this._Flags & 0x40) != 0;
    }

    public boolean hasBeenDeleted() {
        return (this._Flags & 0x20) != 0;
    }

    public boolean hasChanged() {
        return (this._Flags & 1) != 0;
    }

    public boolean hasDebugData() {
        return (this._Flags & 8) != 0;
    }

    public boolean hasSidefileDataSet() {
        return (this._Flags & 2) != 0;
    }

    public int moduleID() {
        return this._ModuleID;
    }

    public String moduleName() {
        if (this._ModuleName != null) {
            return this._ModuleName.toString();
        }
        return null;
    }

    public String fullPathModuleName() {
        if (this._FullPathModuleName != null) {
            return this._FullPathModuleName.toString();
        }
        return null;
    }

    public String moduleInformationalMessage() {
        if (this._ModuleInformationalMessage != null) {
            return this._ModuleInformationalMessage.toString();
        }
        return null;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) {
        EPDC_DumpUtils.NameVal[] attrConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(64, "New"), new EPDC_DumpUtils.NameVal(32, "Deleted"), new EPDC_DumpUtils.NameVal(1, "Changed"), new EPDC_DumpUtils.NameVal(8, "Debug data"), new EPDC_DumpUtils.NameVal(4, "Has parts"), new EPDC_DumpUtils.NameVal(128, "Invalid"), new EPDC_DumpUtils.NameVal(2, "Has set sidefile data")};
        try {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "ModuleID", this.moduleID());
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Flags", this._Flags, attrConstants);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "ModuleName", this.moduleName());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "FullModuleName", this.fullPathModuleName());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "ModuleInfoMsg", this.moduleInformationalMessage());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getDescription() {
        return "Module change item";
    }

    @Override
    int getPacketID() {
        return 12;
    }
}

