/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdLogLine;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ECPLog
extends EPDC_ChangeItem {
    public static final ECPLog[] EMPTY = new ECPLog[0];
    private static final EStdLogLine[] EMPTYLOGLINES = new EStdLogLine[0];
    private EStdLogLine[] _logLines = EMPTYLOGLINES;

    ECPLog(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        dataInputStream.skipBytes(4);
        int numCommandLogLines = dataInputStream.readInt();
        int lineArrayOffset = dataInputStream.readInt();
        OffsetDataInputStream dis = new OffsetDataInputStream(byteBuffer, lineArrayOffset);
        this._logLines = new EStdLogLine[numCommandLogLines];
        int i = 0;
        while (i < numCommandLogLines) {
            this._logLines[i] = EStdLogLine.createLogLine(dis, engineSession);
            ++i;
        }
    }

    public EStdLogLine[] getLogLines() {
        return this._logLines;
    }

    public int getNumLogLines() {
        return this._logLines.length;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) {
        StringBuilder buffer = new StringBuilder();
        try {
            int i = 0;
            while (i < this._logLines.length) {
                buffer.setLength(0);
                if (this._logLines[i] == null) {
                    EPDC_DumpUtils.writeVariable(dataOutputStream, "[" + i + "]", "NULL");
                } else {
                    switch (this._logLines[i]._logLineType) {
                        case 1: {
                            buffer.append("(cmdlog) ");
                            break;
                        }
                        case 3: {
                            buffer.append("(pgmerr) ");
                            break;
                        }
                        case 2: {
                            buffer.append("(pgmout) ");
                            break;
                        }
                        case 5: {
                            buffer.append("(cmdecho) ");
                            break;
                        }
                        case 6: {
                            buffer.append("(hidden) ");
                            break;
                        }
                    }
                    buffer.append(EPDC_DumpUtils.makePrintable(this._logLines[i].getLogLineString()));
                    EPDC_DumpUtils.beginStructure(dataOutputStream, "[" + i + "] " + buffer.toString());
                    this._logLines[i].writeEPDC(dataOutputStream);
                    EPDC_DumpUtils.endStructure(dataOutputStream);
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getDescription() {
        return "Log change item";
    }

    @Override
    int getPacketID() {
        return 13;
    }
}

