/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdBranchPoints;
import com.ibm.debug.pdt.internal.epdc.EStdBranchPointsHit;
import com.ibm.debug.pdt.internal.epdc.EStdFileFlowPoints;
import com.ibm.debug.pdt.internal.epdc.EStdFlowPointsHit;
import com.ibm.debug.pdt.internal.epdc.EStdNumberList;
import com.ibm.debug.pdt.internal.epdc.EStdTraceEntry;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class ECPCC
extends EPDC_ChangeItem {
    public static final ECPCC[] EMPTY = new ECPCC[0];
    private static final byte EXECUTABLELINES = 1;
    private static final byte HITLINES = 2;
    private static final byte FLOWPOINTS = 3;
    private static final byte FLOWPOINTSHIT = 4;
    private static final byte TRACE = 5;
    private static final byte BRANCHPOINTS = 6;
    private static final byte BRANCHPOINTSHIT = 7;
    private static final EStdNumberList[] EMPTYNUMBERLIST = new EStdNumberList[0];
    private static final EStdFileFlowPoints[] EMPTYFLOWPOINTS = new EStdFileFlowPoints[0];
    private static final EStdFlowPointsHit[] EMPTYFLOWPOINTSHIT = new EStdFlowPointsHit[0];
    private static final EStdTraceEntry[] EMPTYTRACEENTRIES = new EStdTraceEntry[0];
    private static final EStdBranchPoints[] EMPTYBRANCHPOINTS = new EStdBranchPoints[0];
    private static final EStdBranchPointsHit[] EMPTYBRANCHPOINTSHIT = new EStdBranchPointsHit[0];
    private ArrayList<EStdNumberList> fExecutableLines;
    private ArrayList<EStdNumberList> fHitLines;
    private ArrayList<EStdFileFlowPoints> fFileFlowPoints;
    private ArrayList<EStdFlowPointsHit> fFlowPointsHit;
    private ArrayList<EStdTraceEntry> fTraceEntries;
    private ArrayList<EStdBranchPoints> fBranchPoints;
    private ArrayList<EStdBranchPointsHit> fBranchPointsHits;
    private TYPE fType;
    private int fNumItems;

    public ECPCC(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        byte type = dis.readByte();
        switch (type) {
            case 1: {
                this.fType = TYPE.EXECUTABLELINES;
                this.fExecutableLines = new ArrayList();
                break;
            }
            case 2: {
                this.fType = TYPE.HITLINES;
                this.fHitLines = new ArrayList();
                break;
            }
            case 3: {
                this.fType = TYPE.FLOWPOINTS;
                this.fFileFlowPoints = new ArrayList();
                break;
            }
            case 4: {
                this.fType = TYPE.FLOWPOINTSHIT;
                this.fFlowPointsHit = new ArrayList();
                break;
            }
            case 5: {
                this.fType = TYPE.TRACE;
                this.fTraceEntries = new ArrayList();
                break;
            }
            case 6: {
                this.fType = TYPE.BRANCHPOINTS;
                this.fBranchPoints = new ArrayList();
                break;
            }
            case 7: {
                this.fType = TYPE.BRANCHPOINTSHIT;
                this.fBranchPointsHits = new ArrayList();
                break;
            }
        }
        if (3 != dis.skipBytes(3)) {
            PDTCoreUtils.logString(this, "Error reading reserved bits in CC packet.", 2);
        }
        this.fNumItems = dis.readInt();
        int offset = dis.readInt();
        if (this.fNumItems == 0) {
            return;
        }
        OffsetDataInputStream ois = new OffsetDataInputStream(byteBuffer, offset);
        int i = 0;
        while (i < this.fNumItems) {
            switch (type) {
                case 1: {
                    this.fExecutableLines.add(new EStdNumberList(byteBuffer, ois, engineSession));
                    break;
                }
                case 2: {
                    this.fHitLines.add(new EStdNumberList(byteBuffer, ois, engineSession));
                    break;
                }
                case 3: {
                    this.fFileFlowPoints.add(new EStdFileFlowPoints(byteBuffer, ois, engineSession));
                    break;
                }
                case 4: {
                    this.fFlowPointsHit.add(new EStdFlowPointsHit(byteBuffer, ois, engineSession));
                    break;
                }
                case 5: {
                    this.fTraceEntries.add(new EStdTraceEntry(byteBuffer, ois, engineSession));
                    break;
                }
                case 6: {
                    this.fBranchPoints.add(new EStdBranchPoints(byteBuffer, ois, engineSession));
                    break;
                }
                case 7: {
                    this.fBranchPointsHits.add(new EStdBranchPointsHit(byteBuffer, ois, engineSession));
                    break;
                }
            }
            ++i;
        }
    }

    public TYPE getType() {
        return this.fType;
    }

    public EStdNumberList[] getExecutableLines() {
        if (this.fExecutableLines == null) {
            return EMPTYNUMBERLIST;
        }
        return this.fExecutableLines.toArray(new EStdNumberList[this.fExecutableLines.size()]);
    }

    public EStdNumberList[] getHitLines() {
        if (this.fHitLines == null) {
            return EMPTYNUMBERLIST;
        }
        return this.fHitLines.toArray(new EStdNumberList[this.fHitLines.size()]);
    }

    public EStdFileFlowPoints[] getFileFlowPoints() {
        if (this.fFileFlowPoints == null) {
            return EMPTYFLOWPOINTS;
        }
        return this.fFileFlowPoints.toArray(new EStdFileFlowPoints[this.fFileFlowPoints.size()]);
    }

    public EStdFlowPointsHit[] getFlowPointsHit() {
        if (this.fFlowPointsHit == null) {
            return EMPTYFLOWPOINTSHIT;
        }
        return this.fFlowPointsHit.toArray(new EStdFlowPointsHit[this.fFlowPointsHit.size()]);
    }

    public EStdTraceEntry[] getTraceEntries() {
        if (this.fTraceEntries == null) {
            return EMPTYTRACEENTRIES;
        }
        return this.fTraceEntries.toArray(new EStdTraceEntry[this.fTraceEntries.size()]);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Type", this.getType().toString());
        EPDC_DumpUtils.beginStructure(dataOutputStream, "Items[" + this.fNumItems + "]");
        switch (this.getType()) {
            case EXECUTABLELINES: {
                for (EStdNumberList item : this.fExecutableLines) {
                    item.writeEPDC(dataOutputStream);
                }
                break;
            }
            case HITLINES: {
                for (EStdNumberList item : this.fHitLines) {
                    item.writeEPDC(dataOutputStream);
                }
                break;
            }
            case FLOWPOINTS: {
                for (EStdFileFlowPoints item : this.fFileFlowPoints) {
                    item.writeEPDC(dataOutputStream);
                }
                break;
            }
            case FLOWPOINTSHIT: {
                for (EStdFlowPointsHit item : this.fFlowPointsHit) {
                    item.writeEPDC(dataOutputStream);
                }
                break;
            }
            case TRACE: {
                for (EStdTraceEntry item : this.fTraceEntries) {
                    item.writeEPDC(dataOutputStream);
                }
                break;
            }
            case BRANCHPOINTS: {
                for (EStdBranchPoints item : this.fBranchPoints) {
                    item.writeEPDC(dataOutputStream);
                }
                break;
            }
            case BRANCHPOINTSHIT: {
                for (EStdBranchPointsHit item : this.fBranchPointsHits) {
                    item.writeEPDC(dataOutputStream);
                }
                break;
            }
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
    }

    @Override
    public String getDescription() {
        return "Code Coverage change item";
    }

    @Override
    int getPacketID() {
        return 18;
    }

    public EStdBranchPoints[] getBranchPoints() {
        if (this.fBranchPoints == null) {
            return EMPTYBRANCHPOINTS;
        }
        return this.fBranchPoints.toArray(new EStdBranchPoints[this.fBranchPoints.size()]);
    }

    public EStdBranchPointsHit[] getBranchPointsHits() {
        if (this.fBranchPoints == null) {
            return EMPTYBRANCHPOINTSHIT;
        }
        return this.fBranchPointsHits.toArray(new EStdBranchPointsHit[this.fBranchPointsHits.size()]);
    }

    public static enum TYPE {
        EXECUTABLELINES,
        HITLINES,
        FLOWPOINTS,
        FLOWPOINTSHIT,
        TRACE,
        BRANCHPOINTS,
        BRANCHPOINTSHIT;

    }
}

