/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EEveryClause;
import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdEnhancedWatchBPData;
import com.ibm.debug.pdt.internal.epdc.EStdEventBPData;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdModuleLoadData;
import com.ibm.debug.pdt.internal.epdc.EStdOccurrenceBPData;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.EStdWatchBPData;
import com.ibm.debug.pdt.internal.epdc.EStdZeroAddressBPData;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class ECPBreakpoint
extends EPDC_ChangeItem
implements Serializable {
    public static final ECPBreakpoint[] EMPTY = new ECPBreakpoint[0];
    private transient int _bkpID;
    private transient short _bkpType;
    private transient short _bkpAttr;
    private transient EStdString _bkpEngineSpecificData;
    private transient int _bkpEntryID;
    private EStdView[] _context;
    private short _bkpFlags;
    private int _bkpDU;
    private int _bkpByteCount;
    private EEveryClause _clause;
    private EStdString _breakpointAction;
    private EStdView _bkpOriginalLocation;
    private EStdString _bkpStmtNum;
    private EStdString _bkpAddress;
    private EStdString _varPtr;
    private EStdEventBPData _eventBPData;
    private EStdString fModuleName;
    private EStdString fPartName;
    private EStdString _fileNamePtr;
    private EStdExpression2 _conditionalExpr;
    private boolean fIsStopSynchronous;
    private static final long serialVersionUID = 20100831L;

    ECPBreakpoint() {
    }

    ECPBreakpoint(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        this._bkpID = dataInputStream.readInt();
        this._bkpFlags = dataInputStream.readShort();
        this._bkpType = dataInputStream.readShort();
        dataInputStream.skipBytes(4);
        this._bkpAttr = dataInputStream.readShort();
        this.fIsStopSynchronous = (this._bkpAttr & 0x80) != 0;
        this._clause = new EEveryClause(dataInputStream);
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            switch (this._bkpType) {
                case 5: {
                    this._eventBPData = new EStdModuleLoadData(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession, false);
                    this._varPtr = ((EStdModuleLoadData)this._eventBPData).getModuleName();
                    break;
                }
                case 12: {
                    this._eventBPData = new EStdModuleLoadData(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession, true);
                    this._varPtr = ((EStdModuleLoadData)this._eventBPData).getModuleName();
                    break;
                }
                case 6: {
                    this._eventBPData = new EStdWatchBPData(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
                    this._varPtr = ((EStdWatchBPData)this._eventBPData).getAddrOrExpr();
                    break;
                }
                case 7: {
                    EStdEnhancedWatchBPData bpdata = new EStdEnhancedWatchBPData(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
                    this._eventBPData = bpdata;
                    this._varPtr = new EStdString(bpdata.getBreakpointExpression(), engineSession);
                    break;
                }
                case 8: {
                    EStdOccurrenceBPData bpData = new EStdOccurrenceBPData(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
                    this._eventBPData = bpData;
                    this._varPtr = bpData.getCondition();
                    break;
                }
                case 13: {
                    EStdZeroAddressBPData zaData = new EStdZeroAddressBPData(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
                    this._eventBPData = zaData;
                    this._varPtr = zaData.getIgnoreList();
                    break;
                }
                default: {
                    this._varPtr = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
                    break;
                }
            }
        } else {
            switch (this._bkpType) {
                case 13: {
                    EStdZeroAddressBPData zaData = new EStdZeroAddressBPData(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
                    this._eventBPData = zaData;
                    this._varPtr = zaData.getIgnoreList();
                    break;
                }
            }
        }
        offset = dataInputStream.readInt();
        if (offset != 0) {
            this.fModuleName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this.fPartName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._fileNamePtr = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._conditionalExpr = new EStdExpression2(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._bkpByteCount = dataInputStream.readInt();
        offset = dataInputStream.readInt();
        if (offset != 0) {
            this._bkpEngineSpecificData = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._bkpEntryID = dataInputStream.readInt();
        this._bkpOriginalLocation = new EStdView(dataInputStream);
        this._bkpDU = dataInputStream.readInt();
        offset = dataInputStream.readInt();
        if (offset != 0) {
            this._bkpAddress = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._bkpStmtNum = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        int numberOfViews = dataInputStream.readUnsignedShort();
        boolean useSourceLineBreakpointFormat = this.getEPDCEngineSession().supportsAmbiguousBreakpoints();
        if (!useSourceLineBreakpointFormat) {
            numberOfViews = engineSession.getNumViews();
        }
        this._context = new EStdView[numberOfViews + 1];
        this._context[0] = null;
        int i = 1;
        while (i < this._context.length) {
            this._context[i] = new EStdView(dataInputStream);
            ++i;
        }
        if (engineSession.supportsBreakpointActions() && (offset = dataInputStream.readInt()) != 0) {
            this._breakpointAction = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public int getId() {
        return this._bkpID;
    }

    public short getType() {
        String macro;
        if (this.getEPDCEngineSession().supportsMacroBreakpoints() && this._bkpType == 2 && (macro = this.getEntryName()) != null && macro.indexOf("[macro") > 0) {
            return 3;
        }
        return this._bkpType;
    }

    public EEveryClause getClause() {
        return this._clause;
    }

    public String getEntryName() {
        if (this._varPtr == null) {
            return null;
        }
        return this._varPtr.toString();
    }

    public String getModuleName() {
        if (this.fModuleName == null) {
            return null;
        }
        return this.fModuleName.toString();
    }

    public String getPartName() {
        if (this.fPartName == null) {
            return null;
        }
        return this.fPartName.toString();
    }

    public String getFileName() {
        if (this._fileNamePtr == null) {
            return null;
        }
        return this._fileNamePtr.toString();
    }

    public String getStatementNumber() {
        if (this._bkpStmtNum == null) {
            return null;
        }
        return this._bkpStmtNum.toString();
    }

    public int getEntryID() {
        return this._bkpEntryID;
    }

    public EStdView getOriginalLocation() {
        return this._bkpOriginalLocation;
    }

    public String getAddress() {
        if (this._bkpAddress == null) {
            return null;
        }
        return this._bkpAddress.toString();
    }

    public String getOccurrenceCondition() {
        return this._varPtr.toString();
    }

    public String getEngineSpecificData() {
        if (this._bkpEngineSpecificData == null) {
            return null;
        }
        return this._bkpEngineSpecificData.toString();
    }

    public boolean isNew() {
        return (this._bkpFlags & 0x4000) != 0;
    }

    public boolean isEnabled() {
        return (this._bkpFlags & 0x1000) != 0;
    }

    public void overrideEnabled(boolean enabled) {
        this._bkpFlags = enabled ? (short)(this._bkpFlags | 0x1000) : (short)(this._bkpFlags & 0xFFFFEFFF);
    }

    public boolean isDeleted() {
        return (this._bkpFlags & 0x8000) != 0;
    }

    public boolean isDeferred() {
        return (this._bkpAttr & 0x4000) != 0;
    }

    public boolean isCaseSensitive() {
        return (this._bkpAttr & 0x2000) != 0;
    }

    public boolean isStopSynchronous() {
        return this.fIsStopSynchronous;
    }

    public boolean isAutoSetEntry() {
        return (this._bkpAttr & 0x400) != 0;
    }

    public boolean isReadOnly() {
        return (this._bkpAttr & 0x200) != 0;
    }

    public boolean isDoNotRestore() {
        return (this._bkpAttr & 0x100) != 0;
    }

    public EStdView[] getContexts() {
        return this._context;
    }

    public int getDU() {
        return this._bkpDU;
    }

    public int getByteCount() {
        return this._bkpByteCount;
    }

    public String getExprString() {
        if (this._conditionalExpr == null) {
            return null;
        }
        return this._conditionalExpr.getExpressionString();
    }

    public EStdExpression2 getConditionalExpr() {
        return this._conditionalExpr;
    }

    public String getBreakpointAction() {
        if (this._breakpointAction != null) {
            return this._breakpointAction.toString();
        }
        return null;
    }

    public EStdEventBPData getEventBPData() {
        return this._eventBPData;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) {
        EPDC_DumpUtils.NameVal[] bkpFlagConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(32768, "BkpDeleted"), new EPDC_DumpUtils.NameVal(16384, "BkpNew"), new EPDC_DumpUtils.NameVal(8192, "BkpInvalid"), new EPDC_DumpUtils.NameVal(4096, "BkpEnabled"), new EPDC_DumpUtils.NameVal(2048, "BkpChanged"), new EPDC_DumpUtils.NameVal(1024, "BkpAllEnabled"), new EPDC_DumpUtils.NameVal(512, "BkpChild"), new EPDC_DumpUtils.NameVal(256, "BkpParent")};
        EPDC_DumpUtils.NameVal[] bkpAttrConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(32768, "reserved"), new EPDC_DumpUtils.NameVal(16384, "BkpCPAttrDefer"), new EPDC_DumpUtils.NameVal(8192, "BkpCPAttrDeferActive"), new EPDC_DumpUtils.NameVal(4096, "BkpCPAttrDeferAmbiguous"), new EPDC_DumpUtils.NameVal(2048, "BkpCPAttrDeferFailed"), new EPDC_DumpUtils.NameVal(1024, "BkpCPAttrAutoSetEntry"), new EPDC_DumpUtils.NameVal(512, "BkpCPAttrReadOnly"), new EPDC_DumpUtils.NameVal(256, "BkpCPAttrDoNotRestore"), new EPDC_DumpUtils.NameVal(128, "BkpCPAttrSyncStop")};
        try {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Breakpoint_ID", this.getId());
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "BreakPoint_Flag", this._bkpFlags, bkpFlagConstants);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "BreakPoint_Type", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, ".*BkpType.*", this.getType()));
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Type_Qual", this.getType());
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "BreakPoint_Attr", this._bkpAttr, bkpAttrConstants);
            if (this.getClause() != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "EveryC");
                this.getClause().writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "EveryC", "NULL");
            }
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Breakpoint Specific");
            switch (this._bkpType) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 13: {
                    this._eventBPData.writeEPDC(dataOutputStream);
                    break;
                }
                default: {
                    EPDC_DumpUtils.writeVariable(dataOutputStream, "var_ptr", this.getEntryName());
                }
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "DllName_Ptr", this.getModuleName());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "SourceName_Ptr", this.getPartName());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "FileName_Ptr", this.getFileName());
            if (this.getConditionalExpr() != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Conditional Expression");
                this.getConditionalExpr().writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Conditional Expression", "NULL");
            }
            EPDC_DumpUtils.writeVariable(dataOutputStream, "ByteCount", this.getByteCount());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "EngineSpecific_Data", this.getEngineSpecificData());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Entry_ID", this.getEntryID());
            if (this.getOriginalLocation() != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Original location");
                this.getOriginalLocation().writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Original location", "NULL");
            }
            EPDC_DumpUtils.writeVariable(dataOutputStream, "DU", this.getDU());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Address", this.getAddress());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Statement", this.getStatementNumber());
            if (this.getContexts() != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Views");
                int i = 0;
                while (i < this.getContexts().length) {
                    if (this.getContexts()[i] != null) {
                        EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i + "]");
                        this.getContexts()[i].writeEPDC(dataOutputStream);
                        EPDC_DumpUtils.endStructure(dataOutputStream);
                    }
                    ++i;
                }
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Views", "NULL");
            }
            if (this.getBreakpointAction() != null) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Commands", this.getBreakpointAction());
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Commands", "NULL");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getDescription() {
        return "Breakpoint change item";
    }

    @Override
    int getPacketID() {
        return 2;
    }
}

