/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ECCFilter
extends EPDC_Structures {
    private static final int FIXED_LENGTH = 10;
    private TYPE fCategory;
    private EStdString fFilter;
    private boolean fInclude;

    protected ECCFilter(boolean include, TYPE category, String filter, EPDC_EngineSession engineSession) {
        this.fCategory = category;
        this.fFilter = new EStdString(filter, engineSession);
        this.fInclude = include;
    }

    public ECCFilter(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this.fInclude = dataInputStream.readByte() == 1;
        byte type = dataInputStream.readByte();
        switch (type) {
            case 2: {
                this.fCategory = TYPE.LINE;
                break;
            }
            case 1: {
                this.fCategory = TYPE.FILE;
                break;
            }
            default: {
                this.fCategory = TYPE.MODULE;
            }
        }
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this.fFilter = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if (dataInputStream.skipBytes(4) != 4) {
            PDTCoreUtils.logString(this, "Error reading reserved bits in ECCFilter.", 2);
        }
    }

    @Override
    int getFixedLen() {
        return 10 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + ECCFilter.getTotalBytes(this.fFilter);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.beginStructure(dataOutputStream, "Filter");
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Include", this.fInclude);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Type", this.fCategory.toString());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Filter", this.fFilter);
        EPDC_DumpUtils.endStructure(dataOutputStream);
    }

    @Override
    public String getDescription() {
        return "CC filter";
    }

    void output(DataOutputStream dataOutputStream, int baseOffset) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeByte(this.fInclude ? 1 : 0);
        switch (this.fCategory) {
            case LINE: {
                dataOutputStream.writeByte(2);
                break;
            }
            case FILE: {
                dataOutputStream.writeByte(1);
                break;
            }
            default: {
                dataOutputStream.writeByte(0);
            }
        }
        int offset = 10 + baseOffset;
        ECCFilter.writeOffsetOrZero(dataOutputStream, offset + super.getVarLen(), this.fFilter);
        dataOutputStream.write(new byte[4]);
        if (this.fFilter != null) {
            this.fFilter.output(dataOutputStream);
        }
    }

    public static enum TYPE {
        MODULE,
        FILE,
        LINE;

    }
}

